<?php

namespace App\Http\Services;

use App\Models\Category;
use App\Models\Log;

class CategoryService extends BaseService
{

    public function addCategoryHandle($userInfo, $categoryInfo) {
        $result = [
            'res' => false,
            'msg' => '添加成功',
            'data' => [],
        ];

        if (!isset($categoryInfo['name']) || mb_strlen($categoryInfo['name']) == 0 || mb_strlen($categoryInfo['name']) > 32) {
            $result['msg'] = '名称异常';
            return $result;
        }

        if (!isset($categoryInfo['sort']) || !is_numeric($categoryInfo['sort']) || $categoryInfo['sort'] < 0 || $categoryInfo['sort'] > 999999) {
            $result['msg'] = '排序异常';
            return $result;
        }

        // 准备写入
        $insertCategory = [
            'name' => $categoryInfo['name'],
            'level' => 1,
            'sort' => $categoryInfo['sort'],
            'updated_by' => $userInfo['id'],
        ];
        $insertRes = (new Category())->insertData($insertCategory);
        if (false === $insertRes) {
            $result['msg'] = '添加失败';
            return $result;
        }

        (new Log())->insertData(['operator' => $userInfo['id'] ?? 0, 'url' => '添加分类', 'type' => 1, 'content' => json_encode($insertCategory, JSON_UNESCAPED_UNICODE)]);

        $result['res'] = true;
        return $result;
    }

    public function getCategoryListHandle($platform) {
        $result = [
            'res' => true,
            'msg' => '获取成功',
            'data' => [],
        ];

        if($platform != 'web'){
            $where = ['is_pub'=>1];
        }else{
            $where = [];
        }
        $categoryModel = new Category();
        $categoryList = $categoryModel->selectDataWithField($where, ['id', 'name','is_pub' ,'sort'], 'sort', 'DESC');

        $result['data']['list'] = $categoryList;
        return $result;
    }

    public function deleteCategoryHandle($userInfo, $categoryInfo) {
        $result = [
            'res' => false,
            'msg' => '删除成功',
            'data' => [],
        ];

        if (!isset($categoryInfo['category_id']) || !is_numeric($categoryInfo['category_id']) || $categoryInfo['category_id'] <= 0) {
            $result['msg'] = '分类id异常';
            return $result;
        }
        $categoryInfo['category_id'] = intval($categoryInfo['category_id']);

        $categoryModel = new Category();
        $existedInfo = $categoryModel->findDataWithField(['id' => $categoryInfo['category_id']], ['id']);
        if (empty($existedInfo)) {
            $result['msg'] = '分类不存在';
            return $result;
        }

        $deleteRes = $categoryModel->deleteData(['id' => $categoryInfo['category_id']]);
        if (false === $deleteRes) {
            $result['msg'] = '删除失败';
            return $result;
        }

        (new Log())->insertData(['operator' => $userInfo['id'] ?? 0, 'url' => '删除分类', 'type' => 3, 'object_id' => $categoryInfo['category_id'], 'content' => json_encode(['id' => $categoryInfo['category_id']], JSON_UNESCAPED_UNICODE)]);

        $result['res'] = true;
        return $result;
    }

    public function pubCategoryHandle($userInfo, $categoryInfo) {
        $result = [
            'res' => false,
            'msg' => '操作成功',
            'data' => [],
        ];

        if (!isset($categoryInfo['category_id']) || !is_numeric($categoryInfo['category_id']) || $categoryInfo['category_id'] <= 0) {
            $result['msg'] = '分类id异常';
            return $result;
        }
        if (!isset($categoryInfo['handle_id']) || !is_numeric($categoryInfo['handle_id']) || $categoryInfo['handle_id'] <= 0) {
            $result['msg'] = '操作id异常';
            return $result;
        }
        $categoryInfo['category_id'] = intval($categoryInfo['category_id']);
        $categoryInfo['handle_id'] = intval($categoryInfo['handle_id']);  // 1 上架 2 下架

        $categoryModel = new Category();
        $existedInfo = $categoryModel->findDataWithField(['id' => $categoryInfo['category_id']], ['id']);
        if (empty($existedInfo)) {
            $result['msg'] = '分类不存在';
            return $result;
        }

        $updateData = [
           'is_pub' =>  $categoryInfo['handle_id'] == 1 ? 1 : 0
        ];
        $categoryModel->updateData(['id' => $categoryInfo['category_id']], $updateData);

        (new Log())->insertData(['operator' => $userInfo['id'] ?? 0, 'url' => '上下架分类', 'type' => 2, 'content' => json_encode($updateData, JSON_UNESCAPED_UNICODE)]);

        $result['res'] = true;
        return $result;
    }

    public function getCategoryInfoHandle($userInfo, $categoryId) {
        $result = [
            'res' => false,
            'msg' => '获取成功',
            'data' => [],
        ];

        if ($categoryId <= 0) {
            $result['msg'] = '分类id异常';
            return $result;
        }

        $categoryModel = new Category();
        $categoryInfo = $categoryModel->findDataWithField(['id' => $categoryId], ['id', 'name', 'is_pub','sort']);
        if (empty($categoryInfo)) {
            $result['msg'] = '分类不存在';
            return $result;
        }

        $result['res'] = true;
        $result['data'] = $categoryInfo;
        return $result;
    }

    public function updateCategoryHandle($userInfo, $categoryInfo) {
        $result = [
            'res' => false,
            'msg' => '更新成功',
            'data' => [],
        ];

        if (!isset($categoryInfo['category_id']) || !is_numeric($categoryInfo['category_id']) || $categoryInfo['category_id'] <= 0) {
            $result['msg'] = '分类id异常';
            return $result;
        }
        $categoryInfo['category_id'] = intval($categoryInfo['category_id']);

        $categoryModel = new Category();
        $categoryExistedInfo = $categoryModel->findDataWithField(['id' => $categoryInfo['category_id']], ['id']);
        if (empty($categoryExistedInfo)) {
            $result['msg'] = '分类不存在';
            return $result;
        }

        // 需要更新的字段
        $updateData = [];

        if (isset($categoryInfo['name'])) {
            if (mb_strlen($categoryInfo['name']) == 0 || mb_strlen($categoryInfo['name']) > 32) {
                $result['msg'] = '名称异常';
                return $result;
            }

            $updateData['name'] = $categoryInfo['name'];
        }

        if (isset($categoryInfo['sort'])) {
            if (!is_numeric($categoryInfo['sort']) || $categoryInfo['sort'] < 0 || $categoryInfo['sort'] > 999999) {
                $result['msg'] = '排序值异常';
                return $result;
            }

            $updateData['sort'] = intval($categoryInfo['sort']);
        }

        if (!empty($updateData)) {
            $updateRes = $categoryModel->updateData(['id' => $categoryInfo['category_id']], $updateData);
            if (false === $updateRes) {
                $result['msg'] = '更新失败';
                return $result;
            }
        }

        (new Log())->insertData(['operator' => $userInfo['id'] ?? 0, 'url' => '编辑保存分类', 'type' => 2, 'content' => json_encode($updateData, JSON_UNESCAPED_UNICODE)]);

        $result['res'] = true;
        return $result;
    }


}
