<?php

/**
 * @param $phone
 * @return false|int
 * 校验手机号
 */
function checkPhone($phone)
{
    return preg_match("/^1[123456789]\d{9}$/", $phone);
}

//身份证
function validateIdCard($string) {
    if (preg_match("/^\d{6}(15|16|17|18|19|20|21|22|23)?\d{2}(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])\d{3}(\d|X|x)$/", $string)) {
        return true; // 字符串符合要求
    } else {
        return false; // 字符串不符合要求
    }
}

function getRandomChars($input = '', $number = 4) {
    if ($input === '') {
        $input = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    }

    if ($number < 1 || $number > 20) {
        $number = 4;
    }

    return substr(str_shuffle($input), 0, $number);
}

function isValidJson($param) {
    // 如果 $param 是一个有效的 JSON 对象或数组
    if (is_array($param) || is_object($param)) {
        // 将对象或数组转换为 JSON 字符串
        $jsonString = json_encode($param);

        // 重新解码，并检查是否能够还原成原始数据
        return (json_last_error() === JSON_ERROR_NONE && json_decode($jsonString, true) === $param);
    }

    return false;
}

function splitArrayByParts($array, $parts) {
    if (!is_array($array)) {
        return [];
    }

    $parts = intval($parts);
    if ($parts <= 0) {
        $parts = 1;
    }

    // 每份数组的个数
    $chunkSize = ceil(count($array) / $parts);

    return array_chunk($array, $chunkSize);
}

function isValidDateStrtotime($date, $format = 'Y-m-d') {
    $timestamp = strtotime($date);

    // 无法转换为时间戳，说明格式不合法
    if ($timestamp === false) {
        return false;
    }

    return date($format, $timestamp) === $date;
}

function isValidDateTime($dateTime, $format = 'Y-m-d H:i') {
    $dt = DateTime::createFromFormat($format, $dateTime);
    return $dt && ($dt->format($format) === $dateTime);
}