<?php

use Illuminate\Support\Facades\Route;

// 分类管理
Route::group(['prefix'=> 'category'], function () {
    // admin-添加分类
    Route::post('add', ['uses' => 'CategoryController@addCategory', 'label' => '分类管理', 'description' => '添加分类']);

    // all-获取分类列表
    Route::get('list', ['uses' => 'CategoryController@getCategoryList', 'label' => '分类管理', 'description' => '获取分类列表']);

    // admin-删除分类
    Route::post('delete', ['uses' => 'CategoryController@deleteCategory', 'label' => '分类管理', 'description' => '删除分类']);

    // admin-编辑获取分类信息
    Route::get('info', ['uses' => 'CategoryController@getCategoryInfo', 'label' => '分类管理', 'description' => '编辑获取分类信息']);

    // admin-编辑保存分类
    Route::post('update', ['uses' => 'CategoryController@updateCategory', 'label' => '分类管理', 'description' => '编辑保存分类']);

    // admin-上下架分类
    Route::post('pub', ['uses' => 'CategoryController@pubCategory', 'label' => '上下下架分类', 'description' => '上下下架分类']);

});
