#!/bin/bash

containerCount=`docker ps -a | grep "tj_tool" | grep -v "grep" | wc -l`
if [ $containerCount -eq 0 ]
then
  docker run -itd --privileged=true --restart=always \
    --privileged=true \
    -v $(pwd):/data/www/project \
    -v /data/cronlog_tjapp:/data/cronlog \
    -v /data/container/nginx/tjapp:/usr/local/nginx/conf/vhost \
    -v /data/container/nginx/nginx.conf:/usr/local/nginx/conf/nginx.conf \
    -v /data/container/php/etc:/usr/local/php/etc \
    -p 9091:9091 \
    -p 9094:9094 \
    -p 9097:9097 \
    --name tj_tool registry.cn-hangzhou.aliyuncs.com/wuzhouhui/lnp-develop:v15 \
    /usr/sbin/init
fi
