<?php

namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class DealRecordGoods extends Base
{
    //表名声明
    protected $table = 'yh_deal_record_goods';
    use SoftDeletes;

    //主键声明
    protected $primaryKey = 'id';
    protected $dates = ['deleted_at'];

    public function getGoodsNotDeliverList($where = [], $field = [], $pagesize = 20) {
//        DB::enableQueryLog();

        $data = DB::table('yh_deal_record_goods as ydrg')
            ->leftJoin('yh_deal_record_user as ydru', 'ydrg.deal_record_user_id', '=', 'ydru.id')
            ->leftJoin('yh_deal_record as ydr', 'ydrg.deal_record_id', '=', 'ydr.id')
            ->where($where)
            ->select($field)
            ->orderBy('ydr.id', 'DESC')
            ->paginate($pagesize);

//        var_dump(DB::getQueryLog());die;

        if (empty($data)) {
            return [];
        } else {
            return $data->toArray();
        }
    }

}
