<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Services\VideoService;

class VideoController extends BaseController
{
    //数据处理层初始化
    protected $accountService;

    /**
     * 构造方法,初始化service
     * @access public
     * @param Request $request Request 对象
     */
    public function __construct() {
        $this->videoService = new VideoService();
    }

    /**
     * 添加视频
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function addVideo(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $videoInfo = $request->json()->all();

        $result = $this->videoService->addVideoHandle($userInfo, $videoInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 获取视频列表
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getVideoList(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $platform = $request->input('platform', '');

        $searchParam = [];
        $searchParam['page'] = $request->input('page', 1);
        $searchParam['page_size'] = $request->input('page_size', 20);

        $result = $this->videoService->getVideoListHandle($platform, $searchParam);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 删除视频
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function deleteVideo(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $videoInfo = $request->json()->all();

        $result = $this->videoService->deleteVideoHandle($userInfo, $videoInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 编辑获取视频信息
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getVideoInfo(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $videoId = (int)$request->input('video_id', '');

        $result = $this->videoService->getVideoInfoHandle($userInfo, $videoId);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 编辑保存视频
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateVideo(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $videoInfo = $request->json()->all();

        $result = $this->videoService->updateVideoHandle($userInfo, $videoInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 修改视频发布状态
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateVideoStatus(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $videoInfo = $request->json()->all();

        $result = $this->videoService->updateVideoStatusHandle($userInfo, $videoInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

}
