<?php

namespace App\Http\Controllers;
use App\Lib\Captcha;
use Illuminate\Http\Request;
use App\Http\Services\LoginService;

class OpenCourseController extends BaseController
{
    //数据处理层初始化
    protected $loginService;

    /**
     * 构造方法,初始化service
     * @access public
     * @param Request $request Request 对象
     */
    public function __construct() {
        $this->loginService = new LoginService();
    }

    //优惠吗最大开课数
    public function couponCourse(Request $request) {
        $phone = $request->post('phone', '');
        $couponCode = $request->post('couponCode', '');
        if(empty($phone)){
            return $this->respondError(10001, 'phone不能为空');
        }
        if(empty($couponCode)){
            return $this->respondError(10001, '优惠券码不能为空');
        }

        $result = $this->loginService->couponCourseSrevice($phone, $couponCode);

        return $this->respond($result);
    }

    //批量开课
    public function openCourse(Request $request){
        $ssoId = $request->post('ssoId', '');
        $couponCode = $request->post('couponCode', '');
        $spuIdsJson = $request->post('spuIds', '');
        if(empty($ssoId)){
            return $this->respondError(10001, '用户id不能为空');
        }
        if(empty($couponCode)){
            return $this->respondError(10001, '优惠券码不能为空');
        }
        if(empty($spuIdsJson)){
            return $this->respondError(10001, 'spuid不能为空');
        }
        $spuIds = json_decode($spuIdsJson, true);

        $result = $this->loginService->openCourseSrevice($ssoId, $spuIds, $couponCode);

        return $this->respond($result);
    }


}











































