<?php

namespace App\Http\Controllers;

use App\Exceptions\Constants;

class BaseController extends Controller
{
    /**
     * Return generic json response with the given data.
     *
     * @param $data
     * @param int $statusCode
     * @param array $headers
     * @return \Illuminate\Http\JsonResponse
     */
    protected function respond($data, $statusCode = 200, $headers = []) {
        return response()->json($data, $statusCode, $headers);
    }

    /**
     * Respond with error.
     *
     * @param $message
     * @param $statusCode
     * @param $params
     * @return \Illuminate\Http\JsonResponse
     */
    protected function respondError($statusCode, $message = '', $params = []) {
        $data = [
            'code' => $statusCode,
            'msg' => empty($message) ? Constants::msg($statusCode):$message,
        ];

        if (!empty($params)) {
            $data['data'] = $params;
        }

//        if(config('app.debug')) {
//            $data['params'] = $params;
//        }

        return $this->respond($data, 200);
    }

    /**
     * Respond with success.
     *
     * @param $data
     * @param $params
     * @return \Illuminate\Http\JsonResponse
     */
    protected function respondSuccess($data = [], $params = []) {
        $responseData = [
            'code' => Constants::SUCCESS,
            'msg' => Constants::msg(Constants::SUCCESS),
            'data' => $data
        ];

//        if(config('app.debug')) {
//            $responseData['cost'] = microtime(true) - $_SERVER['REQUEST_TIME'];
//            $responseData['params'] = $params;
//        }

        return $this->respond($responseData, 200);
    }

}