<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Services\BannerService;
use Illuminate\Support\Facades\Storage;

class BannerController extends BaseController
{
    //数据处理层初始化
    protected $courseService;

    /**
     * 构造方法,初始化service
     * @access public
     * @param Request $request Request 对象
     */
    public function __construct() {
        $this->courseService = new BannerService();
    }

    //学员列表
    public function lst(Request $request) {
        $phone = $request->input('phone', "");
        $useraNme = $request->input('user_name', "");
        $pageId = (int)$request->input('page_id', "1");
        $pageSize = (int)$request->input('page_size', "20");
        $result = $this->courseService->listService($phone, $useraNme, $pageId, $pageSize);
        return $this->respond($result);
    }

    //学员基本信息获取
    public function info(Request $request) {
        $id = (int)$request->input('id', "");
        if (empty($id)) {
            return $this->respondError(10001, '参数错误');
        }

        $result = $this->courseService->infoService($id);
        return $this->respond($result);
    }

    //学员基本信息获取
    public function edit(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $id = (int)$request->input('id', "");
        $base_info_report = $request->input('base_info_report', "");
        $first_school = $request->input('first_school', "");
        $same_area = $request->input('same_area', "");
        $except_area = $request->input('except_area', "");
   $same_profession = $request->input('same_profession', "");
        $except_profession = $request->input('except_profession', "");

        if (empty($id)) {
            return $this->respondError(10001, '参数错误');
        }
        if (empty($base_info_report)) {
            return $this->respondError(10001, '请填写基础信息测评报告');
        }
        if (empty($first_school)) {
            return $this->respondError(10001, '请填写【首选院校（规划师填写）】');
        }
        if (empty($same_area)) {
            return $this->respondError(10001, '请填写【达成一致的意向地区排序（规划师填写）】');
        }
        if (empty($except_area)) {
            return $this->respondError(10001, '请填写【达成一致的绝不接受地区（规划师填写）】');
        }
        if (empty($same_profession)) {
            return $this->respondError(10001, '请填写【达成一致的专业排序（规划师填写）】');
        }
        if (empty($except_profession)) {
            return $this->respondError(10001, '请填写【达成一致的绝不接受专业（规划师填写）】');
        }

        $dpdateData = [
            'base_info_report' =>$base_info_report,
            'first_school' =>$first_school,
            'same_area' =>$same_area,
            'except_area' =>$except_area,
            'same_profession' =>$same_profession,
            'except_profession' =>$except_profession,
        ];
        $result = $this->courseService->editService($id,$dpdateData, $userInfo);
        return $this->respond($result);
    }

    //
    public function delete(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $id = (int)$request->input('id', "");
        if (empty($id)) {
            return $this->respondError(10001, '参数错误');
        }

        $result = $this->courseService->deleteService($id, $userInfo);
        return $this->respond($result);
    }

    //学员评价
    public function evalLst(Request $request) {
        $phone = $request->input('phone', "");
        $useraNme = $request->input('user_name', "");
        $pageId = (int)$request->input('page_id', "1");
        $pageSize = (int)$request->input('page_size', "20");
        $result = $this->courseService->evalLstService($phone, $useraNme, $pageId, $pageSize);
        return $this->respond($result);
    }

    //中公高招高考志愿规划咨询单
    public function consultLst(Request $request) {
        $phone = $request->input('phone', "");
        $useraNme = $request->input('user_name', "");
        $pageId = (int)$request->input('page_id', "1");
        $pageSize = (int)$request->input('page_size', "20");
        $result = $this->courseService->consultLstService($phone, $useraNme, $pageId, $pageSize);
        return $this->respond($result);
    }


}











































































