<?php

use Illuminate\Support\Facades\Route;

// 视频管理
Route::group(['prefix'=> 'video'], function () {
    // admin-添加视频
    Route::post('add', ['uses' => 'VideoController@addVideo', 'label' => '视频管理', 'description' => '添加视频']);

    // all-获取视频列表
    Route::get('list', ['uses' => 'VideoController@getVideoList', 'label' => '视频管理', 'description' => '获取视频列表']);

    // admin-删除视频
    Route::post('delete', ['uses' => 'VideoController@deleteVideo', 'label' => '视频管理', 'description' => '删除视频']);

    // admin-编辑获取视频信息
    Route::get('info', ['uses' => 'VideoController@getVideoInfo', 'label' => '视频管理', 'description' => '编辑获取视频信息']);

    // admin-编辑保存视频
    Route::post('update', ['uses' => 'VideoController@updateVideo', 'label' => '视频管理', 'description' => '编辑保存视频']);

    // admin-修改视频发布状态
    Route::post('status/update', ['uses' => 'VideoController@updateVideoStatus', 'label' => '视频管理', 'description' => '修改视频发布状态']);

});

