<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/



//退出
Route::group(['prefix'=> 'logout'], function () {
    Route::post('logout', ['uses' => 'LoginController@logout', 'label' => '退出登录',]);
});


//学员信息
Route::group(['prefix'=> 'student'], function () {
    Route::get('list', ['uses' => 'BannerController@lst', 'label' => '列表',]);
    Route::get('info', ['uses' => 'BannerController@info', 'label' => '列表',]);
    Route::post('edit', ['uses' => 'BannerController@edit', 'label' => '列表',]);
    Route::post('del', ['uses' => 'BannerController@delete', 'label' => '列表',]);
    Route::get('eval_list', ['uses' => 'BannerController@evalLst', 'label' => '列表',]);
    Route::get('consult_list', ['uses' => 'BannerController@consultLst', 'label' => '列表',]);
//    Route::get('eval_list', ['uses' => 'BannerController@studentConsultSubmit', 'label' => '列表',]);

});

//学校信息
Route::group(['prefix'=> 'school'], function () {
    Route::get('getconfig', ['uses' => 'SchoolController@getConfig', 'label' => '列表',]);
    Route::get('list', ['uses' => 'SchoolController@lst', 'label' => '列表',]);
    Route::get('special_list', ['uses' => 'SchoolController@specialList', 'label' => '列表',]);
    Route::get('special_detail', ['uses' => 'SchoolController@specialDetail', 'label' => '列表',]);
    Route::get('score_province', ['uses' => 'SchoolController@specialProvince', 'label' => '院校分数线',]);
    Route::get('score_major_province', ['uses' => 'SchoolController@specialMajorProvince', 'label' => '专业分数线',]);
    Route::get('plan_before', ['uses' => 'SchoolController@planBefore', 'label' => '招生信息',]);

});

//admin user

Route::group(['prefix'=> 'adminuser'], function () {
    Route::post('add', ['uses' => 'AdminUserController@addUser', 'label' => '新增',]);
    Route::get('list', ['uses' => 'AdminUserController@getList', 'label' => '列表',]);
    Route::post('edit', ['uses' => 'AdminUserController@editUser', 'label' => '编辑',]);
    Route::get('del', ['uses' => 'AdminUserController@delUser', 'label' => '删除',]);
});

// 获取用户信息
Route::get('user/info', ['uses' => 'AdminUserController@getUserInfo', 'label' => '获取用户详情信息',]);


// 获取高考志愿预案表列表
Route::group(['prefix'=> 'major/plan'], function () {
    Route::get('list', ['uses' => 'SchoolController@getPlanList', 'label' => '获取高考志愿预案表列表']);
});

// 获取家长报名意向填写列表
Route::group(['prefix'=> 'admin/parents/intention'], function () {
    Route::get('list', ['uses' => 'SchoolController@getAdminParentsIntentionList', 'label' => '获取家长报名意向填写列表']);
});

































