<?php
/**
 * Created by PhpStorm.
 * User: bmb369
 * Date: 2025-04-22
 * Time: 14:16
 */

namespace App\Http\Services;

use App\Exceptions\Constants;
use App\Models\Config;
use App\Models\ParentsIntention;
use App\Models\School;
use App\Models\AreaProvinceModel;
use App\Models\SchoolSpecial;
use App\Models\SchoolSpecialDetail;
use App\Models\SchoolProvincescore;
use App\Models\Log;
use App\Models\StudentPreferenceMajor;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use App\Models\SchoolMajorScore;
use App\Models\SchoolPlanBefore;

class SchoolService extends BaseService{


    public function selectConfigService(){

        $AreaProvinceModel = new AreaProvinceModel();
        $res = $AreaProvinceModel->selectDataWithField(['p_code'=>1], ['id','name']);
        return ['code'=>0, 'msg'=>'success', 'data'=>['area_list'=>$res]];
    }

    public function listService($search, $pageId, $pageSize)
    {

        $where = [
            ['level_name', '=', '本科']
        ];
        if (isset($search['name']) && $search['name']) {
            $where[] = ['name', 'like', "%{$search['name']}%"];
        }
        if (isset($search['type_name']) && $search['type_name']) {
            $where[] = ['type_name', 'like', "{$search['type_name']}%"];
        }
        if (isset($search['province_id']) && $search['province_id']) {
            $where[] = ['province_id', '=', $search['province_id']];
        }
        $field = ['id', 'school_id', 'name', 'logo', 'belong', 'province_name', 'city_name', 'dual_class_name', 'feyy', 'fjbw', 'level_name', 'nature_name', 'tag_name', 'type_name', 'recommend_master_level'];

        $School = new School();
        $list = $School->selectDataWithPage($where, $field, $pageSize,'id', 'asc');

        $result = [];
        $result['page'] = $pageId;
        $result['page_size'] = $pageSize;
        $result['total'] = $list['total'];
        $result['list'] = $list['data'];
        return ['code' => 0, 'msg' => 'success', 'data' => $result];

    }

    public function specialListService($schoolid, $pageId, $pageSize){

        $where = [
            ['school_id','=',$schoolid]
        ];
        $field = ['*'];
        $SchoolSpecial = new SchoolSpecial();


        $list = $SchoolSpecial->selectDataWithPage($where, $field, $pageSize,'id', 'asc');

        $result = [];
        $result['page'] = $pageId;
        $result['page_size'] = $pageSize;
        $result['total'] = $list['total'];
        $result['list'] = $list['data'];
        return ['code' => 0, 'msg' => 'success', 'data' => $result];
    }

    public function specialDetailService($schoolid, $specialid){

        $where = [
            ['school_id','=',$schoolid],
            ['special_id','=',$specialid]
        ];

        $SchoolSpecialDetail = new SchoolSpecialDetail();
        $res = $SchoolSpecialDetail->findData($where);
        return ['code'=>0, 'msg'=>'success', 'data'=>$res];
    }

    public function specialProvinceService($school_id, $province_id, $year, $pageId, $pageSize){

        $where = [
            ['school_id','=',$school_id],
            ['province_id','=',$province_id],
            ['year','=',$year],
        ];

        $SchoolProvincescore = new SchoolProvincescore();
        $list = $SchoolProvincescore->selectDataWithPage($where, ['*'], $pageSize,'id', 'asc');
        $result = [];
        $result['page'] = $pageId;
        $result['page_size'] = $pageSize;
        $result['total'] = $list['total'];
        $result['list'] = $list['data'];

        return ['code' => 0, 'msg' => 'success', 'data' => $result];
    }

    public function planBeforeService($school_id, $province_id, $year, $pageId, $pageSize){

        $where = [
            ['school_id','=',$school_id],
            ['province_id','=',$province_id],
            ['year','=',$year],
        ];

        $SchoolPlanBefore = new SchoolPlanBefore();
        $list = $SchoolPlanBefore->selectDataWithPage($where, ['*'], $pageSize,'id', 'asc');
        $listData = [];
        foreach ($list['data'] as $key => $value) {
            $d = json_decode($value['all_data'], true);
            $list['data'][$key]['all_data'] = $d;
        }
        $result = [];
        $result['page'] = $pageId;
        $result['page_size'] = $pageSize;
        $result['total'] = $list['total'];
        $result['list'] = $list['data'];

        return ['code' => 0, 'msg' => 'success', 'data' => $result];
    }

    public function specialMajorProvinceService($school_id, $province_id, $year, $pageId, $pageSize){


        $AreaProvinceModel = new AreaProvinceModel();
        $res = $AreaProvinceModel->selectDataWithField(['p_code'=>1], ['id','name']);
        $provinceReIds = array_column($res, 'name', 'id');


        $where = [
            ['school_id','=',$school_id],
            ['province_id','=',$province_id],
            ['year','=',$year],
        ];

        $SchoolMajorScore = new SchoolMajorScore();
        $list = $SchoolMajorScore->selectDataWithPage($where, ['*'], $pageSize,'id', 'asc');
        $listData = [];
        foreach ($list['data'] as $key => $value) {
            $d = json_decode($value['all_data'], true);
            $d['province_name'] = $provinceReIds[$value['province_id']] ?? "";
            $d['local_type_name'] = Constants::getType($value['local_type_id']);
            $d['local_batch_name'] = Constants::getType($value['local_batch_id']);
            $listData[] = $d;
        }
        $result = [];
        $result['page'] = $pageId;
        $result['page_size'] = $pageSize;
        $result['total'] = $list['total'];
        $result['list'] = $listData;

        return ['code' => 0, 'msg' => 'success', 'data' => $result];
    }




    public function checkPlanListSearchHandle($searchParam) {
        $result = [
            'res' => true,
            'msg' => '校验成功',
            'data' => [],
        ];

        if ($searchParam['user_name'] !== '') {
            $result['data']['user_name'] = mb_substr($searchParam['user_name'], 0, 32);
        }

        if ($searchParam['phone'] !== '') {
            $result['data']['phone'] = mb_substr($searchParam['phone'], 0, 32);
        }

        if ($searchParam['province'] !== '') {
            $result['data']['province'] = mb_substr($searchParam['province'], 0, 32);
        }

        if ($searchParam['type'] !== '') {
            $searchParam['type'] = intval($searchParam['type']);
            if ($searchParam['type'] >= 1 && $searchParam['type'] <= 2) {
                $result['data']['type'] = $searchParam['type'];
            } else {
                $result['data']['type'] = 1;
            }
        }

        $result['data']['page'] = intval($searchParam['page'] ?? 1);
        if ($result['data']['page'] <= 0) {
            $result['data']['page'] = 1;
        }

        $result['data']['page_size'] = intval($searchParam['page_size'] ?? 20);
        if ($result['data']['page_size'] <= 0 || $result['data']['page_size'] > 100) {
            $result['data']['page_size'] = 20;
        }

        return $result;
    }


    public function getPlanListHandle($userInfo, $searchParam) {
        $result = [
            'res' => true,
            'msg' => '获取成功',
            'data' => [],
        ];

        $where = [];
        if (isset($searchParam['user_name'])) {
            $where[] = ['user_name', 'like', '%' . $searchParam['user_name'] . '%'];
        }
        if (isset($searchParam['phone'])) {
            $where['phone'] = $searchParam['phone'];
        }
        if (isset($searchParam['province'])) {
            $where['province'] = $searchParam['province'];
        }
        $where['type'] = $searchParam['type'];

        $studentPreferenceMajor = new StudentPreferenceMajor();
        $planList = $studentPreferenceMajor->selectDataWithPage($where, ['id', 'user_name', 'phone', 'province', 'subject', 'score', 'rank', 'plan', 'created_at'], $searchParam['page_size'], 'id', 'desc');

        foreach ($planList['data'] as $index => $plan) {
            $planList['data'][$index]['plan'] = json_decode($plan['plan']);
        }

        $result['data']['page'] = $searchParam['page'];
        $result['data']['page_size'] = $searchParam['page_size'];
        $result['data']['total'] = $planList['total'];
        $result['data']['list'] = $planList['data'];
        return $result;
    }

    public function checkAdminParentsIntentionListSearchHandle($searchParam) {
        $result = [
            'res' => true,
            'msg' => '校验成功',
            'data' => [],
        ];

        if ($searchParam['user_name'] !== '') {
            $result['data']['user_name'] = mb_substr($searchParam['user_name'], 0, 32);
        }

        if ($searchParam['phone'] !== '') {
            $result['data']['phone'] = mb_substr($searchParam['phone'], 0, 32);
        }

        if ($searchParam['province'] !== '') {
            $result['data']['province'] = mb_substr($searchParam['province'], 0, 32);
        }

        if ($searchParam['year'] !== '' && is_numeric($searchParam['year'])) {
            $searchParam['year'] = intval($searchParam['year']);
            if ($searchParam['year'] >= 2025 && $searchParam['year'] <= 2099) {
                $result['data']['year'] = $searchParam['year'];
            }
        }

        $result['data']['page'] = intval($searchParam['page'] ?? 1);
        if ($result['data']['page'] <= 0) {
            $result['data']['page'] = 1;
        }

        $result['data']['page_size'] = intval($searchParam['page_size'] ?? 20);
        if ($result['data']['page_size'] <= 0 || $result['data']['page_size'] > 100) {
            $result['data']['page_size'] = 20;
        }

        return $result;
    }

    public function getAdminParentsIntentionListHandle($userInfo, $searchParam) {
        $result = [
            'res' => true,
            'msg' => '获取成功',
            'data' => [],
        ];

        $where = [];
        if (isset($searchParam['user_name'])) {
            $where[] = ['user_name', 'like', '%' . $searchParam['user_name'] . '%'];
        }
        if (isset($searchParam['phone'])) {
            $where['phone'] = $searchParam['phone'];
        }
        if (isset($searchParam['province'])) {
            $where['province'] = $searchParam['province'];
        }
        if (isset($searchParam['year'])) {
            $where['year'] = $searchParam['year'];
        }

        $parentsIntention = new ParentsIntention();
        $intentionList = $parentsIntention->selectDataWithPage($where, ['id', 'user_name', 'phone', 'province', 'year', 'periods', 'created_at'], $searchParam['page_size'], 'id', 'desc');

        // 获取对应年份的配置项
        $configModel = new Config();
        $configWhere = [];
        $configWhere['type'] = 1;
        $configWhere[] = ['config_key', 'like', 'intention_%'];
        $periodsConfig = $configModel->selectDataWithField($configWhere);
        $periodsList = array_column($periodsConfig, 'config_value', 'config_key');

        foreach ($periodsList as $index => $value) {
            $periodsList[$index] = json_decode($value, true);
        }

        foreach ($intentionList['data'] as $index => $intention) {
            $intentionList['data'][$index]['periods'] = $periodsList['intention_' . $intention['year']][$intention['periods'] - 1] ?? '';
        }

        $result['data']['page'] = $searchParam['page'];
        $result['data']['page_size'] = $searchParam['page_size'];
        $result['data']['total'] = $intentionList['total'];
        $result['data']['list'] = $intentionList['data'];
        return $result;
    }



}



