<?php

namespace App\Http\Services;

use App\Http\Controllers\Controller;
use App\Models\Config;
use Ramsey\Uuid\Uuid;
use Godruoyi\Snowflake\Snowflake;;

class BaseService extends Controller
{
    /**
     * 获取格式化的时间
     * @param  integer $time   [需要转换的unix时间戳]
     * @param  string  $format [转换成的格式]
     * @return [type]          [string]
     */
    public function getDataFormat($time = 0, $format = 'Y-m-d H:i:s')
    {
        if (empty($time)) {
            $time = time();
        }
        return date($format, $time);
    }

    /**
     * 获取配置项
     * @param  [type]  $configKey [key]
     * @param  integer $type      [type]
     * @return [type]             [description]
     */
    public function getConfigValue($configKey, $type = 1)
    {
        //实例化config model
        $configModel = new Config();

        //查询条件
        $configWhere = [];
        $configWhere['config_key'] = $configKey;
        $configWhere['type'] = $type;
        $configField = ['config_value'];
        $configInfo = $configModel->findDataWithField($configWhere, $configField);

        return $configInfo['config_value'] ?? '';
    }

    protected function buildTree($list, $pid = 0) {
        $tree = [];

        foreach ($list as $data) {
            if ($data['parent_id'] == $pid) {
                $data['children'] = $this->buildTree($list, $data['id']);
                $tree[] = $data;
            }
        }

        return $tree;
    }

    protected function getUUid() {
        return Uuid::uuid4()->toString();
    }

    protected function getSnowflake() {
        $snowflake = new Snowflake(1, 1);
        $snowflake->setStartTimeStamp(strtotime('2024-01-01')*1000);

        return $snowflake->id();
    }

}
