<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Services\AccountService;

class AccountController extends BaseController
{
    //数据处理层初始化
    protected $accountService;

    /**
     * 构造方法,初始化service
     * @access public
     * @param Request $request Request 对象
     */
    public function __construct() {
        $this->accountService = new AccountService();
    }

    /**
     * 获取我的钱包详情
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAccountOpenInfo(Request $request) {
        $userInfo = $request->attributes->get('user_info');

        $result = $this->accountService->getAccountOpenInfoHandle($userInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 获取客服的开关状态
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getServiceOpenInfo(Request $request) {
        $userInfo = $request->attributes->get('user_info');

        $result = $this->accountService->getServiceOpenInfoHandle($userInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 修改客服的开关状态
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateServiceOpenStatus(Request $request) {
        $isOpen = $request->input('is_open', 0);

        $result = $this->accountService->updateServiceOpenStatusHandle($isOpen);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 修改订单的开关状态
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateOrderServiceOpenStatus(Request $request) {
        $isOpen = $request->input('is_open', 0);

        $result = $this->accountService->updateOrderServiceOpenStatusHandle($isOpen);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 获取我的钱包详情
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAccountInfo(Request $request) {
        $userInfo = $request->attributes->get('user_info');

        $result = $this->accountService->getAccountInfoHandle($userInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 提交充值申请
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function applyRecharge(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $applyInfo = $request->json()->all();

        $result = $this->accountService->applyRechargeHandle($userInfo, $applyInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 获取充值申请列表
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAccountList(Request $request) {
        $userInfo = $request->attributes->get('user_info');

        $searchParam = [];
        $searchParam['status'] = $request->input('status', '');
        $searchParam['is_recharge'] = $request->input('is_recharge', '');
        $searchParam['class_phone'] = $request->input('class_phone', '');
        $searchParam['user_phone'] = $request->input('user_phone', '');
        $searchParam['page'] = $request->input('page', 1);
        $searchParam['page_size'] = $request->input('page_size', 20);

        $checkResult = $this->accountService->checkAccountListSearchHandle($searchParam);
        if (empty($checkResult['res'])) {
            return $this->respondError(30001, $checkResult['msg'] ?? '');
        }
        $checkResult['data']['platform'] = $request->input('platform', '');

        $result = $this->accountService->getAccountListHandle($userInfo, $checkResult['data']);
        if (empty($result['res'])) {
            return $this->respondError(30002, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 充值申请审核
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function applyCheck(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $checkInfo = $request->json()->all();

        $result = $this->accountService->applyCheckHandle($userInfo, $checkInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 充值
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function accountRecharge(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $rechargeInfo = $request->json()->all();

        $result = $this->accountService->accountRechargeHandle($userInfo, $rechargeInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 查看充值转账详情
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAccountRecord(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $platform = $request->input('platform', '');
        $applyId = (int)$request->input('apply_id', '0');

        $result = $this->accountService->getAccountRecordHandle($platform, $userInfo, $applyId);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 发送短信验证码
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function smsCodeSend(Request $request) {
        $userInfo = $request->attributes->get('user_info');

        $result = $this->accountService->smsCodeSendHandle($userInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 转账
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function accountTransfer(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $transferInfo = $request->json()->all();

        $result = $this->accountService->accountTransferHandle($userInfo, $transferInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 查看充值转账详情
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function dealRecordAccountCheck(Request $request) {

        $searchParam = [];
        $searchParam['date_start'] = $request->input('date_start', '');
        $searchParam['date_end'] = $request->input('date_end', '');
        $searchParam['reception_name'] = $request->input('reception_name', '');

        $result = $this->accountService->dealRecordAccountCheckHandle($searchParam);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 查询我的快递
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getExpressList(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $searchParam = [];
        $searchParam['class_phone'] = $request->input('class_phone', '');

        $result = $this->accountService->getExpressListHandle($userInfo, $searchParam);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 对话补全
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getDSChatCompletions(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $textInfo = $request->json()->all();

        $this->accountService->getDSChatCompletionsHandle($userInfo, $textInfo);

    }

}
