<?php

namespace App\Lib;

use Illuminate\Support\Facades\Log;

class SmsCode
{
    protected $smsUrl;
    protected $smsAccount;
    protected $smsPasswd;
    protected $smsSign;

    public function __construct() {
        $this->smsUrl = env('SMS_URL');
        $this->smsAccount = env('SMS_ACCOUNT');
        $this->smsPasswd = env('SMS_PASSWORD');
        $this->smsSign = env('SMS_SIGN');
    }

    public function sendSms($phone, $content) {
        $result = [
            'res' => false,
            'msg' => '发送成功',
            'data' => [],
        ];

        if (empty($this->smsUrl) || empty($this->smsAccount) || empty($this->smsPasswd) || empty($this->smsSign)) {
            $result['msg'] = '配置缺失';
            return $result;
        }

        // 拼接请求数据
        $data = [
            'account' => $this->smsAccount,
            'password' => md5($this->smsPasswd),
            'phones' => $phone,
            'content' => $content,
            'sign' => $this->smsSign,
            'sendtime' => date('YmdHi'),
        ];

        $responseStr = $this->http_post_json(__FUNCTION__, $this->smsUrl . "/Submit", json_encode($data));
        $response = json_decode($responseStr, true);
        if (false === $response || $response['result'] != 0) {
            $result['msg'] = '发送失败';
            Log::error("短信发送失败, 响应: " . $responseStr);
            return $result;
        }

        $result['res'] = true;
        $result['data']['msgid'] = $response['msgid'] ?? '';
        return $result;
    }

    /**
     * PHP发送Json对象数据, 发送HTTP请求
     *
     * @param string $url 请求地址
     * @param $data
     * @return String
     */
    private function http_post_json($functionName, $url, $data) {
        $ch = curl_init ( $url );
        curl_setopt ( $ch, CURLOPT_POST, 1 );
        curl_setopt ( $ch, CURLOPT_HEADER, 0 );
        curl_setopt ( $ch, CURLOPT_FRESH_CONNECT, 1 );
        curl_setopt ( $ch, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt ( $ch, CURLOPT_FORBID_REUSE, 1 );
        curl_setopt ( $ch, CURLOPT_TIMEOUT, 30 );
        curl_setopt ( $ch, CURLOPT_HTTPHEADER, array ('Content-Type: application/json; charset=utf-8', 'Content-Length: ' . strlen ( $data ) ) );
        curl_setopt ( $ch, CURLOPT_POSTFIELDS, $data );
        $ret = curl_exec ( $ch );
//        echo $functionName . " : Request Info : url: " . $url . " ,send data: " . $data . "  \n";
//        echo $functionName . " : Respnse Info : " . $ret . "  \n";
        curl_close ( $ch );
        return $ret;
    }

}



///**
// * 大汉三通短信云平台http接入实例：json格式
// *
// */
////Base URL
//define ( 'URL', "http://wt.3tong.net/json/sms" );
////账号，必填
//define ( 'ACCOUNT', "dh1234" );
////密码，必填
//define ( 'PASSWORD', md5 ( "%eNTE67G" ) );
////短信签名，必填
//define ( 'SIGN', "【大汉三通】" );
////短信子码,选填
//define ( 'SUBCODE', "853101" );
//
//$ret = sendSms ( "13621876969", "您的验证码是:1234", uniqid ( rand (), true ), "201505051230" );
//$ret = getSmsReport ();
////$ret = getSms ();
////$ret = getBalance ();
//
//
///**
// * 发送短信
// * @param string $phones 手机号码,
// * @param string $content 短信内容
// * @param string $msgid 短信ID(唯一，UUID)，可空
// * @param string $sendtime 短信发送时间，可空
// *
// */
//function sendSms($phones, $content, $msgid, $sendtime) {
//    // 发送数据包json格式：{"account":"8528","password":"e717ebfd5271ea4a98bd38653c01113d","msgid":"2c92825934837c4d0134837dcba00150","phones":"15711666132","content":"您好，您的手机验证码为：430237。","sign":"【8528】","subcode":"8528","sendtime":"201405051230"}
//    $data = array ('account' => ACCOUNT, 'password' => PASSWORD, 'msgid' => $msgid, 'phones' => $phones, 'content' => $content, 'sign' => SIGN, 'subcode' => SUBCODE, 'sendtime' => $sendtime );
//    return http_post_json ( __FUNCTION__, URL . "/Submit", json_encode ( $data ) );
//}
//
//


