<?php

namespace App\Lib;

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Reader\IReadFilter;

class CustomReadFilter implements IReadFilter
{
    private $startRow;
    private $endRow;
    private $startColumn;
    private $endColumn;

    public function __construct($startRow, $endRow, $startColumn, $endColumn)
    {
        $this->startRow = $startRow;
        $this->endRow = $endRow;
        $this->startColumn = $startColumn;
        $this->endColumn = $endColumn;
    }

    public function readCell($column, $row, $worksheetName = ''): bool {
        // 判断当前单元格是否在读取区域内
        return (
            $row >= $this->startRow && $row <= $this->endRow &&
            $column >= $this->startColumn && $column <= $this->endColumn
        );
    }
}