<?php

$inputNumber = isset($_GET['amount']) ? intval($_GET['amount']) : 0;
function calculateGroups($number) {
    // 计算一半分5组
    $halfGroup1 = floor($number / 2);
    $halfGroup1Threshold = max(500, floor($halfGroup1 / 5));

    // 计算剩下一半分10组
    $halfGroup2 = $number - $halfGroup1;
    $halfGroup2Threshold = max(500, floor($halfGroup2 / 10));

    return [
        'half1' => [
            'groups' => 5,
            'threshold' => $halfGroup1Threshold,
            'amountPerGroup' => $halfGroup1Threshold
        ],
        'half2' => [
            'groups' => 10,
            'threshold' => $halfGroup2Threshold,
            'amountPerGroup' => $halfGroup2Threshold
        ]
    ];
}

// 从命令行获取参数
  if (isset($argv[1]) || $inputNumber >0 ) {
        if ($inputNumber < 0 ){
            $inputNumber = intval($argv[1]);
        }
    $result = calculateGroups($inputNumber);

    // 输出结果
    echo "总额：" . $inputNumber . "\n\n";

    echo "一半分5组：\n<br>";
    for ($i = 1; $i <= $result['half1']['groups']; $i++) {
        echo "第 " . $i . " 期，金额：" . $result['half1']['amountPerGroup'] . "\n<br>";
    }

    $totalAmount = 0;

    echo "\n剩下一半分10组：\n<br>";
    for ($i = 1; $i <= $result['half2']['groups']; $i++) {
        $amount = $result['half2']['amountPerGroup'];
        // 计算总额
        $totalAmount += $amount;

        if ($totalAmount <= $inputNumber && $i <= $result['half2']['groups'] / 2) {
            echo "第 " . $i . " 期，金额：" . $amount . "\n<br>";
        } else {
            break;
        }
    }
} else {
    echo "请提供一个数字作为参数。\n";
}
?>