<?php
/**
 * Created by PhpStorm.
 * User: bmb369
 * Date: 2024-05-06
 * Time: 19:13
 */
namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Services\AddrService;
use App\Lib\Guid;

class AddressController extends BaseController{



    public function getAreaList(){
        $service = new AddrService();
        $data = $service->getPAndCDataService();
        return $this->respond($data);
    }
    // 用户管理：设置用户地区数据用
    public function getAreaListCity(){
        $service = new AddrService();
        $data = $service->getListCityService();
        // 数据处理：顶部增加 全国，area_code 100000
        $data['data'] = array_merge([['name'=>'全国','area_code'=>100000,'p_code'=>1,]], $data['data']);
        return $this->respond($data);
    }
    // 订单列表，筛选下拉框用
    public function getAreaListCityUser(Request $request){
        $userInfo = $request->attributes->get('user_info');
        $is_admin = $userInfo['is_admin'];// 超管
        $service = new AddrService();
        if($is_admin || strpos(','.$userInfo['area_pro_name'].',', ',全国,' ) !== false){
            // 超管或者 有全国权限
            $data = $service->getListCityService();
            return $this->respond($data);
        }else{
            $area_pro = $userInfo['area_pro'];
            $data = $service->getListCityUserService($area_pro );
            return $this->respond($data);
        }

    }


    //添加收货地址
    public function add(Request $request){
        $userid = $request->attributes->get('user_info')['id'];
        $phone_code = $request->post('code', "+86");
        $phone = $request->post('phone', "");
        $person = $request->post('name', "");
        $country = $request->post('country', 1);
        $country_name = $request->post('country_name', '中国');
        $p_code = $request->post('p', 0);
        $p_name = $request->post('p_n', 0);
        $c_code = $request->post('c', 0);
        $c_name = $request->post('c_n', 0);
        $area_code = $request->post('a', 0);
        $area_name = $request->post('a_n', 0);
        $t_code = $request->post('t', 0);
        $t_name = $request->post('t_n', 0);
        $address = $request->post('addr', "");
        $isDefault = $request->post('is_default', "0"); // 1设置为默认
        //$userid = $request->get('def', 0);
//         $userid = $request->get('area_code', "");
        if(empty($userid) || empty($phone)|| empty($person)|| empty($address)
            || empty($p_name)|| empty($c_name) || empty($area_name) || empty($country_name)){
            return $this->respondError(10001, '参数异常');
        }
        if(empty($phone) || false == checkPhone($phone)){
            return $this->respondError(10002, '手机号不正确');
        }
        if (mb_strlen($person) > 32){  //密码复杂度等后面再加，
            return $this->respondError(10001, '名字不能超过32个字符');
        }
        if (mb_strlen($address) > 100){  //密码复杂度等后面再加，
            return $this->respondError(10001, '详细地址不能超过100个字符');
        }
        
        $service = new AddrService();
        $data = $service->addAddr($userid,$phone_code,$phone,$person,$country,$country_name,
            $p_code,$p_name,$c_code,$c_name,$area_code,$area_name,$t_code,$t_name,$address, $isDefault);
        return  response()->json($data);
    }

    //添加收货地址
    public function edit(Request $request){
        $userid = $request->attributes->get('user_info')['id'];
        $id = $request->post('id', "0");
        $phone_code = $request->post('code', "+86");
        $phone = $request->post('phone', "");
        $person = $request->post('name', "");
        $country = $request->post('country', 1);
        $country_name = $request->post('country_name', '中国');
        $p_code = $request->post('p', 0);
        $p_name = $request->post('p_n', 0);
        $c_code = $request->post('c', 0);
        $c_name = $request->post('c_n', 0);
        $area_code = $request->post('a', 0);
        $area_name = $request->post('a_n', 0);
        $t_code = $request->post('t', 0);
        $t_name = $request->post('t_n', 0);
        $address = $request->post('addr', "");
        $isDefault = $request->post('is_default', "0"); // 1设置为默认

        //$userid = $request->get('def', 0);
//         $userid = $request->get('area_code', "");
        if(empty($id) ||empty($userid) || empty($phone)|| empty($person)|| empty($address)
            || empty($p_name)|| empty($c_name) || empty($area_name)  || empty($country_name)){
            return $this->respondError(10001, '参数异常');
        }
        if(empty($phone) || false == checkPhone($phone)){
            return $this->respondError(10002, '手机号不正确');
        }
        if (mb_strlen($person) > 32){  //密码复杂度等后面再加，
            return $this->respondError(10001, '名字不能超过32个字符');
        }
        if (mb_strlen($address) > 100){  //密码复杂度等后面再加，
            return $this->respondError(10001, '详细地址不能超过100个字符');
        }


        $service = new AddrService();
        $data = $service->editAddr($id,$userid,$phone_code,$phone,$person,$country,$country_name,
            $p_code,$p_name,$c_code,$c_name,$area_code,$area_name,$t_code,$t_name,$address, $isDefault);
        return  response()->json($data);
    }


    
    //获取收货地址
    public function lst(Request $request){
        $userid = $request->attributes->get('user_info')['id'];
        if(empty($userid)){
            return $this->respondError(10001, '参数异常');
        }
        
        $service = new AddrService();
        $data = $service->getAddr($userid);
        return  response()->json($data);
    }
    
    //删除收货地址
    public function del(Request $request){
        $userid = $request->attributes->get('user_info')['id'];
        $id = $request->get('id', 0);
        
        if($id<=0){
                return $this->respondError(10001, '参数异常');
        }
        
        $service = new AddrService();
        $data = $service->delAddr($userid,$id);
        
        return  response()->json($data);
    }
    
    //设置为默认收货地址
    public function set(Request $request){
        $userid = $request->attributes->get('user_info')['id'];
        $id = $request->get('id', 0);
        
        if($id<=0){
            return $this->respondError(10001, '参数异常');
        }
        
        $service = new AddrService();
        $data = $service->setAddr($userid,$id);
        return  response()->json($data);
    }

}