<?php
/**
 * Created by PhpStorm.
 * User: bmb369
 * Date: 2025-04-22
 * Time: 14:15
 */

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Services\SchoolService;
use Illuminate\Support\Facades\Storage;
class SchoolController extends BaseController{

    protected $schoolService;

    public function __construct() {
        $this->schoolService = new SchoolService();
    }

    public function getConfig(Request $request){
        $result = $this->schoolService->selectConfigService();
        return $this->respond($result);
    }

    //列表
    public function lst(Request $request) {
        $search['name'] = $request->input('name', "");
        $search['province_id'] = (int)$request->input('province_id', 0);
        $search['type_name'] = $request->input('type_name', ""); //院校类型
        $pageId = (int)$request->input('page', "1");
        $pageSize = (int)$request->input('page_size', "20");
        $result = $this->schoolService->listService($search, $pageId, $pageSize);
        return $this->respond($result);
    }

    //获取学校专业列表
    public function specialList(Request $request){
        $school_id = (int)$request->input('school_id', 0);
        if (empty($school_id)) {
            return $this->respondError(10001, 'school_id参数错误');
        }
        $pageId = (int)$request->input('page', "1");
        $pageSize = (int)$request->input('page_size', "20");
        $result = $this->schoolService->specialListService($school_id, $pageId, $pageSize);
        return $this->respond($result);
    }
    //获取学校专业详情
    public function specialDetail(Request $request){
        $school_id = (int)$request->input('school_id', 0);
        $special_id = (int)$request->input('special_id', 0);
        if (empty($school_id)) {
            return $this->respondError(10001, 'school_id参数错误');
        }
        if (empty($special_id)) {
            return $this->respondError(10001, 'special_id参数错误');
        }
        $result = $this->schoolService->specialDetailService($school_id, $special_id);
        return $this->respond($result);
    }

    //获取学校往年招生情况
    public function planBefore(Request $request){
        $school_id = (int)$request->input('school_id', 0);
        $province_id = (int)$request->input('province_id', 0);
        $year = (int)$request->input('year', 2024);
        $pageId = (int)$request->input('page', "1");
        $pageSize = (int)$request->input('page_size', "20");
        if (empty($school_id)) {
            return $this->respondError(10001, 'school_id参数错误');
        }
        if (empty($province_id)) {
            return $this->respondError(10001, 'province_id参数错误');
        }
        if (empty($year)) {
            return $this->respondError(10001, 'year参数错误');
        }
        $result = $this->schoolService->planBeforeService($school_id, $province_id, $year, $pageId, $pageSize);
        return $this->respond($result);
    }

    //获取学校院校历年分数
    public function specialProvince(Request $request){
        $school_id = (int)$request->input('school_id', 0);
        $province_id = (int)$request->input('province_id', 0);
        $year = (int)$request->input('year', 2024);
        $pageId = (int)$request->input('page', "1");
        $pageSize = (int)$request->input('page_size', "20");
        if (empty($school_id)) {
            return $this->respondError(10001, 'school_id参数错误');
        }
        if (empty($province_id)) {
            return $this->respondError(10001, 'province_id参数错误');
        }
        if (empty($year)) {
            return $this->respondError(10001, 'year参数错误');
        }
        $result = $this->schoolService->specialProvinceService($school_id, $province_id, $year, $pageId, $pageSize);
        return $this->respond($result);
    }

    //获取学校专业历年分数
    public function specialMajorProvince(Request $request){
        $school_id = (int)$request->input('school_id', 0);
        $province_id = (int)$request->input('province_id', 0);
        $year = (int)$request->input('year', 2024);
        $pageId = (int)$request->input('page', "1");
        $pageSize = (int)$request->input('page_size', "20");
        if (empty($school_id)) {
            return $this->respondError(10001, 'school_id参数错误');
        }
        if (empty($province_id)) {
            return $this->respondError(10001, 'province_id参数错误');
        }
        if (empty($year)) {
            return $this->respondError(10001, 'year参数错误');
        }
        $result = $this->schoolService->specialMajorProvinceService($school_id, $province_id,$year, $pageId, $pageSize);
        return $this->respond($result);
    }

    /**
     * 获取高考志愿预案表列表
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getPlanList(Request $request) {
        $userInfo = $request->attributes->get('user_info');

        $searchParam = [];
        $searchParam['user_name'] = $request->input('user_name', '');
        $searchParam['phone'] = $request->input('phone', '');
        $searchParam['province'] = $request->input('province', '');
        $searchParam['type'] = (int)$request->input('type', 1);
        $searchParam['page'] = $request->input('page', 1);
        $searchParam['page_size'] = $request->input('page_size', 20);

        $checkResult = $this->schoolService->checkPlanListSearchHandle($searchParam);
        if (empty($checkResult['res'])) {
            return $this->respondError(30001, $checkResult['msg'] ?? '');
        }

        $result = $this->schoolService->getPlanListHandle($userInfo, $checkResult['data']);
        if (empty($result['res'])) {
            return $this->respondError(30002, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 获取家长报名意向填写列表
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getAdminParentsIntentionList(Request $request) {
        $userInfo = $request->attributes->get('user_info');

        $searchParam = [];
        $searchParam['user_name'] = $request->input('user_name', '');
        $searchParam['phone'] = $request->input('phone', '');
        $searchParam['province'] = $request->input('province', '');
        $searchParam['year'] = $request->input('year', '');
        $searchParam['page'] = $request->input('page', 1);
        $searchParam['page_size'] = $request->input('page_size', 20);

        $checkResult = $this->schoolService->checkAdminParentsIntentionListSearchHandle($searchParam);
        if (empty($checkResult['res'])) {
            return $this->respondError(30001, $checkResult['msg'] ?? '');
        }

        $result = $this->schoolService->getAdminParentsIntentionListHandle($userInfo, $checkResult['data']);
        if (empty($result['res'])) {
            return $this->respondError(30002, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

}



