<?php
namespace App\Exceptions;
use Illuminate\Support\Str;
class Constants
{

    /**
     * 基本常量定义
     */
    const SSO_LOGIN_CODE_APP_TYPE = 2;

    const CALLBACK_SIGN_KEY_19 = 'offcn!login_zaixiankt@)))user|(( md5';    // 19课堂回放 回调函数私有key
    const ENCRYPT_SALT = 'offcn!login_zliswe^@)))user|((@myufs';
    const SSO_LOGIN_SIGN_KEY = '9eaf618cca780358d7c98c00dc18e148';
    const ZXKT_VERIFY_KEY = '6dNIHASZwFpVOYl1Qib3G54x780hjfUkKzPuBcWToDEmtgqX9vaeCnrRyMsJ2L';
    const APPLE_COURSE_PREFIX = 'com.eoffcn.classonline.course';
    const MESSAGE_TOKEN='52cZSXuG8UFi8fR4HiE7DV7NhX3UehmsC8y91GBNbxB';


    /**
     * 基本错误类型
     */
    const SUCCESS = 0;    // 成功
    const FAIL = 1;    // 失败
    const FAIL_CODE = 1001;


    const COURSE_PLATFORM_OLD = 1;
    const COURSE_PLATFORM_NEW = 2;



    const ERR_INFO_NOT_EXISTS = -1001;    // 信息不存在
    const ERR_USER_NOT_EXISTS = -1002;    // 用户不存在
    const ERR_EXCEPTION = -1003; //异常错误
    const ERR_USER_LOGIN_TIMEOUT = -1004;    // 用户登陆超时
    const ERR_INFO_SET_FAIL = -1005;    //  信息设置失败


    const ERR_PARAMS_NOT_VALIDATE = -2001;    // 参数不合法
    const ERR_REQUEST_NOT_VALIDATE = -2002;    // 访问不合法
    const ERR_REQUEST_TIMEOUT = -2003;    // 请求已过期
    const ERR_SIGN_INVALIDATE = -2004;    // 签名错误

    const ERR_RESULT_IS_EMPTY = -3001;    // 数据为空


    const ERR_JPUSH_REGISTER = -4001;    // 推送注册失败
    const ERR_JPUSH_LOGOUT = -4002;    // 推送登出失败

    const ERR_DOWNLOAD_RECORD_FAIL = -5001;    // 下载记录存储失败

    const ERR_IM_LOGIN = -6001;    // 融云登陆失败
    const ERR_IM_SEND_FAIL = -6002;    // 融云消息发送失败

    const ERR_FILE_UPLOAD_FAIL = -7001;    // 上传文件失败
    const ERR_FILE_IS_EMPTY = -7002;    // 上传文件不能为空

    const ERR_SELF_HELP_SAVE_FAIL = -8001;    // 自助开课失败
    const ERR_ClOSE_ORDER_FAIL = -8002;    // 关闭订单失败
    const ERR_SUBMIT_ADDRESS_FAIL = -8003;    // 提交地址失败
    
    const ERR_STUDY_RECORD_FAIL = -9001;  //学习记录获取失败


    /**
     * curl code值定义
     */
    const CURL_REQUEST_ERROR = 20001; //curl请求失败
    const CURL_DATA_ERROR = 20002; //返回数据格式错误
    const CURL_EXCEPTION_ERROR = 20003; //curl请求异常code
    const ROUT_EXCEPTION_ERROR = 20004; //路由接口请求异常code
    
    
    const PARAMETER_INPUT_ERROR = 10001; //参数传入失败
    
    //redis缓存key
    const USER_COURSE_KEY = 'user_course_qiyi';
    
    //获取学习记录信息  app平台介入
    const APP_CLIENT_ID = 9;

    const APP_CLIENT_ID_SSO = 7;


    const IDENTITY_ZAIZHI = 1;
    const IDENTITY_DAIYE = 2;
    const IDENTITY_ZAIXIAOSHENG = 3;



    const STATUS_WAITING_POST_ORDER = 31;//代发货状态的订单


    const NEED_ADD_ADDRESS = 1;

    /**
     * @return array
     */
    public static function getIdentityName()
    {

        return array(
            self::IDENTITY_ZAIZHI => '在职',
            self::IDENTITY_DAIYE => '待业',
            self::IDENTITY_ZAIXIAOSHENG => '在校学生',
        );
    }

    /**
     * @return array
     */
    public static function getAppointmentStatusName()
    {

        return array(
            0 => '预约',
            1 => '撤销预约',
            2 => '已预约',
            3 => '已约满',
            4 => '预约'
        );
    }

    /**
     * @return array
     */
    public static function getIdentityNames()
    {

        return array(
            '在职' => self::IDENTITY_ZAIZHI,
            '待业' => self::IDENTITY_DAIYE,
            '在校学生'=> self::IDENTITY_ZAIXIAOSHENG,
        );
    }
    
    //请求 查询时间片段上安排的直播频道信息 返回的code对应的提示信息
    public static  $liveChannalCodes =
        array(
              0 => '成功',
            101 => '该时间段尚未预约课程',
            102 => '该时间段尚未分组安排',
            103 => '该时间段分组信息内容错误',
            );
    
    
    public static $liveDatesCodes = array(
        0=>'成功',
        101=>'该时段您已有课程预约，如调整内容请先取消预约',
        102=>'尝试取消该时间段上没有的预约信息',
        103=>'您约过同样的课程，请不要重复预约',
        104=>'个人信息不完善',
        105=>'课时不足，请购买课时',
        106=>'预约课程失败',
        109=>'截止取消预约',
        110=>'个人信息不完善',
        114=>'当前时间按已经截至预约',
        122=>'当前时间段预约量已满，请选择其他时间段预约',
    );
    /**
     * 错误消息响应
     */
    private static $_errMsg = [
        // 基础错误
        self::SUCCESS => ['成功', 'success'],
        self::FAIL => ['失败', 'fail'],

        self::ERR_INFO_NOT_EXISTS => ['信息不存在', 'info is not exist'],

        self::ERR_USER_NOT_EXISTS => ['用户不存在', 'user is not exist'],

        self::ERR_EXCEPTION => ['异常错误', 'exception err'],

        self::ERR_INFO_SET_FAIL => ['信息设置失败', 'user is not exist'],
        self::ERR_USER_LOGIN_TIMEOUT => ['用户登陆超时', 'user login timeout'],


        self::ERR_PARAMS_NOT_VALIDATE => ['参数不合法', 'params is not validate'],
        self::ERR_REQUEST_NOT_VALIDATE => ['访问不合法', 'request is not validate'],
        
        self::ERR_REQUEST_TIMEOUT => ['请求已过期, 请重试！', 'request is timeout'],
        self::ERR_SIGN_INVALIDATE => ['签名校验错误, 请重试！', 'sign is not validate'],

        self::ERR_RESULT_IS_EMPTY => ['数据为空', 'result is empty'],
        
        self::ERR_JPUSH_REGISTER => ['极光推送注册失败', 'jpush register fail'],
        self::ERR_JPUSH_LOGOUT => ['极光推送登出失败', 'jpush logout fail'],


        self::ERR_IM_LOGIN => ['融云登陆失败', 'rong_cloud login fail'],
        self::ERR_IM_SEND_FAIL => ['融云消息发送失败', 'rong_cloud send msg fail'],


        self::ERR_DOWNLOAD_RECORD_FAIL => ['下载记录存储失败', 'download record fail'],

        self::ERR_IM_LOGIN  => ['登陆IM失败', 'login rongyun im fial'],

        self::ERR_FILE_UPLOAD_FAIL => ['文件上传失败', 'file upload fail'],

        self::ERR_FILE_IS_EMPTY => ['上传文件不能为空', 'file upload is empty'],

        self::ERR_DOWNLOAD_RECORD_FAIL => ['下载记录存储失败', 'download record fail'],

        self::ERR_SELF_HELP_SAVE_FAIL => ['自助开课失败', 'self help save fail'],

        self::ERR_ClOSE_ORDER_FAIL => ['关闭订单失败', 'close order fail'],

        self::ERR_SUBMIT_ADDRESS_FAIL => ['提交地址失败', 'submit address fail'],

        self::ERR_STUDY_RECORD_FAIL => ['学习记录获取失败, 请重试！', 'study record fail']



        //其他业务请在下面对照写中英文错误信息

    ];

    public static function msg($errno, $lang = '')
    {
        $lang = empty($lang) ? config('app.locale'):$lang;
        $lang = 'zh_cn' === $lang ? 0 : 1;
        return self::$_errMsg[$errno][$lang] ?? '';
    }




    //图书邮寄常量定义
    //delivery_process 表 status
    const STATUS_UNSURE = 0; //备货中
    const STATUS_NOT_HAS_DELIVERY= 5; // 暂无图书邮寄信息
    const STATUS_PART_POST= 4; //部分发货
    const STATUS_WAITING_POST = 1; //备货中
    const STATUS_POST = 2; //已发货
    const STATUS_EXPORT = 3; //已导出


    //平台常量
    const PLATFORM_DEFAULT = 0;
    const PLATFORM_U_CLASS = 1;
    //数据是否有效
    const IS_DELETE = 1;//已删除
    const NOT_DELETE = 0;//合法数据

    //是否有需要继续申请的图书
    const HAS_DELIVERY = 1;
    const HAS_NOT_DELIVERY = 0;

    //是否是默认地址
    const IS_DEFAULT = 1;
    const IS_NOT_DEFAULT = 0;


    const EXTRA_STATUS_PURE = 0; //课程下面的图书完全没有下过单
    const EXTRA_STATUS_POST = 1;//课程下面的图书全部被其他课程下过单
    const EXTRA_STATUS_PART_POST = 2; //课程下的图书 部分下过单


    const NOT_LOGIN = 9999;

    //7易接口返回的code码
    const NOT_BUY_COURSE = 2001;
    const NOT_HAS_BOOK_NUMBER = 3;

    const PRODUCT_NAME_SUFFIX = '  (1本)';

    const LESSON_TYPE_XIAOYU = 9;//小雨直播课件的类型，兼融app
    const LESSON_TYPE_XIAO_BAN = 20;//小班直播课件的类型，兼融app
    const PLAT_TYPE_XIAOYU= 3; //【0：无】【1:19课堂】【2：展视互动】【3：小雨直播】

    public static function getUUID(){
        return str_replace('-', '', Str::uuid()->toString());
    }

    public static function getType($num)
    {

        $type = [

            1	=>"理科",
2	=>"文科",
3	=>"综合",
4	=>"艺术类",
5	=>"体育类",
6	=>"本科提前批",
7	=>"本科一批",
8	=>"本科二批",
9	=>"本科三批",
10	=>"专科批",
11	=>"专科提前批",
12	=>"国家专项计划本科批",
13	=>"地方专项计划本科批",
14	=>"本科批",
15	=>"普通类提前批",
16	=>"平行录取一段",
17	=>"平行录取二段",
18	=>"平行录取三段",
19	=>"专科一批",
20	=>"专科二批",
23	=>"体育文",
24	=>"体育理",
25	=>"艺术文",
26	=>"艺术理",
27	=>"民语言体育类",
28	=>"民语言文科",
29	=>"民语言理科",
30	=>"民语言艺术类",
31	=>"蒙授体育",
32	=>"蒙授文科",
33	=>"蒙授理科",
34	=>"蒙授艺术",
36	=>"本科提前批A段",
37	=>"本科提前批B段",
38	=>"普通类平行录取段",
39	=>"提前批专项计划",
40	=>"本科提前二批",
41	=>"本科提前一批",
42	=>"本科提前批自主招生",
43	=>"专项批",
44	=>"本科二批A段",
45	=>"本科二批B段",
46	=>"本科批A段",
47	=>"本科批B段",
48	=>"专科批A段",
49	=>"专科批B段",
50	=>"单设本科批次",
51	=>"本科一批A段",
52	=>"本科一批B段",
53	=>"本科第一批专项",
54	=>"本科二批C段",
55	=>"艺术本科第一批专项",
56	=>"本科第一批预科",
57	=>"本科第二批预科A",
58	=>"本科第二批预科B",
59	=>"精准脱贫专项计划（本科）",
60	=>"精准脱贫专项计划（专科）",
61	=>"国家专项计划本科一批",
62	=>"国家专项计划本科二批",
63	=>"地方专项计划本科一批",
64	=>"地方专项计划本科二批",
65	=>"本科甲批",
66	=>"本科乙批",
69	=>"本科综合评价批",
70	=>"本科零批",
71	=>"地方农村专项计划本科批",
74	=>"国家专项批",
76	=>"提前专项批",
79	=>"地方专项批",
81	=>"高校专项批",
82	=>"专项计划本科一批（贫困专项、南疆单列、对口援疆计划本科一批次）",
83	=>"专项计划本科二批（贫困专项、南疆单列、对口援疆计划本科二批次）",
84	=>"自主招生批",
85	=>"免费师范生批",
86	=>"本科提前批C段",
87	=>"特殊类批",
88	=>"无批次",
89	=>"上海海关学院",
90	=>"特殊类型招生批",
91	=>"本一特殊类型招生批",
92	=>"地方专项计划批",
93	=>"本二特殊类型招生批",
94	=>"农村专项计划批",
95	=>"本科普通批A",
96	=>"本科普通批B",
97	=>"本科“专项生”批",
98	=>"本科一批A1段",
99	=>"国家专项计划批",
100	=>"本科三批A段",
101	=>"专项计划批",
102	=>"本科一批预科班",
103	=>"精准脱贫专项计划本科批",
104	=>"本科二批预科A类",
105	=>"本科二批预科B类",
106	=>"本科二批预科班",
107	=>"专科预科班",
108	=>"贫困专项、南疆单列、对口援疆计划本科一批",
109	=>"贫困专项、南疆单列、对口援疆计划本科二批",
110	=>"本科一批H段（特殊类型招生批）",
111	=>"本科一批I段",
112	=>"本科一批J段",
113	=>"本科二批K段",
114	=>"本科二批L段",
115	=>"本科三批M段",
116	=>"本科三批N段",
117	=>"高职（专科）批P段",
118	=>"高职（专科）批Q段",
119	=>"高职（专科）批R段",
120	=>"高职（专科）批S段",
121	=>"省内预科",
122	=>"本科二批及预科班",
123	=>"艺术A类（本科）",
124	=>"艺术B类（本科）",
125	=>"艺术类（高职专科）",
126	=>"体育类（本科）",
127	=>"体育类（高职专科）",
128	=>"艺术类（本科）",
129	=>"自招线",
130	=>"体育类（本科一批）",
131	=>"体育类（本科二批）",
132	=>"军校军检线",
133	=>"体育类（本、专科）",
134	=>"专科批（独立学院、民办）",
135	=>"体育类（平行录取一段）",
136	=>"体育类（平行录取二段）",
137	=>"汉授体育",
138	=>"汉授美术",
139	=>"蒙授美术",
140	=>"汉授音乐",
141	=>"蒙授音乐",
142	=>"汉授编导",
143	=>"其他艺术",
144	=>"蒙授其他艺术",
145	=>"高分优先投档线",
146	=>"艺术类（本科一批）",
147	=>"艺术类（本科二批）",
148	=>"贫困地区专项计划（本科一批）",
149	=>"贫困地区专项计划（本科二批）",
150	=>"省外院校民族班、民族预科（本科一批）",
151	=>"省外院校民族班、民族预科（本科二批）",
152	=>"省内专项（本科一批）",
153	=>"省内专项（本科二批）",
154	=>"省内院校本科民族预科",
155	=>"体育类（本科三批）",
156	=>"蒙授本科一批",
157	=>"蒙授本科二批",
158	=>"蒙授高职高专",
159	=>"重点本科批",
160	=>"普通本科批（少）",
161	=>"重点本科批",
162	=>"重点本科批（少）",
163	=>"普通本科批",
164	=>"专科批（汉）",
165	=>"专科批（少）",
166	=>"艺术类本科批（汉）",
167	=>"艺术类本科批（少）",
168	=>"艺术类（专科）",
169	=>"体育类本科批（汉）",
170	=>"体育类本科批（少）",
171	=>"体育类（专科）",
172	=>"体育类（本科提前批）",
173	=>"体育类（专科提前批）",
174	=>"艺术类（本科提前批）",
175	=>"体育类（专科提前批）",
176	=>"艺术类（专科提前批）",
177	=>"本科一批（A+A）",
178	=>"本科一批（AA）",
179	=>"本科一批（AB）",
180	=>"本科一批（AB+）",
181	=>"本科一批（B+B）",
182	=>"本科一批（B+B+）",
183	=>"本科一批（BB）",
184	=>"本科一批（BC）",
185	=>"本科一批（历史A，另一门B）",
186	=>"本科一批（历史A，另一门B+）",
187	=>"本科一批（历史B+，另一门B）",
188	=>"本科一批（物理A，另一门B）",
189	=>"本科一批（物理A，另一门B+）",
190	=>"本科一批（物理B+，另一门B）",
191	=>"本科批（高分优先投档线）",
192	=>"地方专项计划本科批（高分优先投档线）",
193	=>"本科二批（B+B）",
194	=>"本科二批（B+B+）",
195	=>"本科二批（BB）",
196	=>"本科二批（BC）",
197	=>"本科二批（CC）",
198	=>"本科二批（历史B，另一门C）",
199	=>"本科二批（历史B+，另一门B）",
200	=>"本科二批（物理B，另一门C）",
201	=>"本科二批（物理B+，另一门B）",
202	=>"本科批（最低分数线）",
203	=>"本科一批B",
204	=>"专科批（CC）",
205	=>"专科批（DD）",
206	=>"专科批（CD）",
207	=>"中外合作办学",
208	=>"中法创新实验班",
209	=>"公费师范生",
210	=>"南疆计划",
211	=>"少数民族预科班",
212	=>"本科提前（蒙授）",
213	=>"少数民族预科班",
214	=>"综合评价",
215	=>"综合评价批",
216	=>"中澳合作",
217	=>"中日合作",
218	=>"卓越工程师班",
219	=>"中美合作",
220	=>"高本贯通",
221	=>"南疆单列",
222	=>"喀什计划",
223	=>"管理会计特色班",
224	=>"诺浩特色班",
225	=>"AHK项目班",
226	=>"校企合作",
227	=>"4+0联合办学",
228	=>"定向公培生",
229	=>"高收费专业",
230	=>"龙潭校区",
231	=>"洺关校区",
232	=>"与承德石油高等专科学校合办",
233	=>"与邢台职业技术学院合办",
234	=>"工程教育实验班",
235	=>"医学部校区",
236	=>"保定校区",
237	=>"渤海校区",
238	=>"秦皇岛校区",
239	=>"晋城校区",
240	=>"汾阳学院",
241	=>"临汾学院",
242	=>"朔州校区",
243	=>"中德学院",
244	=>"其他少数民族",
288	=>"常州校区",
289	=>"张家港校区",
290	=>"淮安校区",
291	=>"高职本科联合培养",
292	=>"按民办机制招生收费",
293	=>"男生",
294	=>"女生",
295	=>"空乘类",
296	=>"高职本科分段培养",
297	=>"海外本科直通车",
298	=>"南通办学点",
299	=>"空乘类专业",
300	=>"地方专项",
301	=>"苏区专项",
302	=>"农林类",
303	=>"职教本科合作实验班",
304	=>"服务外包类",
305	=>"江铜校区",
306	=>"婺源校区",
307	=>"烟台研究院",
308	=>"中国少数民族语言文学",
309	=>"民族预科",
310	=>"马来西亚分校",
311	=>"校企合作软件外包专业济南校区",
312	=>"地方农村专项计划",
313	=>"校企合作软件外包专业",
314	=>"非西藏生定藏就业",
315	=>"边防军人子女预科班",
316	=>"有面试体检要求",
317	=>"菏泽校区",
318	=>"莱芜校区",
319	=>"走读",
320	=>"师范，面向青岛",
321	=>"泰安校区",
322	=>"定向",
323	=>"软件工程",
324	=>"建筑环境与能源应用工程专业",
325	=>"中外合作大连开发区",
326	=>"软件类",
327	=>"材料科学与工程专业",
328	=>"地矿类专业",
329	=>"校企合作软件外包专业青岛校区",
330	=>"非西藏生定藏就业，师范类",
331	=>"采矿工程专业",
332	=>"软件工程专业",
333	=>"荣成校区",
334	=>"煤炭定向",
335	=>"高密校区",
336	=>"临沂校区",
337	=>"高职本科贯通培养",
338	=>"乘务专业",
339	=>"空乘专业",
340	=>"面试合格",
341	=>"航海类专业",
342	=>"美国华盛顿分校",
343	=>"订单班",
344	=>"西校区",
345	=>"高职技师",
346	=>"其他单列",
347	=>"少数民族",
348	=>"较高收费",
349	=>"异地校区",
350	=>"医护类",
351	=>"农林矿",
352	=>"与开封大学联合办学(就读地点：开封大学)",
353	=>"与濮阳市联办濮阳工学院",
354	=>"迈阿密学院",
355	=>"西亚斯国际学院与美国堪萨斯州富特海斯州立大学合办",
356	=>"西亚斯国际学院",
357	=>"体育学院",
358	=>"办学就读地点在许昌",
359	=>"与嵩山少林武术职业学院联合办学，前两年就读嵩山",
360	=>"中外课程合作",
361	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(01专业)",
362	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(02专业)",
363	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(03专业)",
364	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(04专业)",
365	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(05专业)",
366	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(06专业)",
367	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(07专业)",
368	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(08专业)",
369	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(09专业)",
370	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(10专业)",
371	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(11专业)",
372	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(12专业)",
373	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(13专业)",
374	=>"中外合作（英才校区）",
375	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(14专业)",
376	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(15专业)",
377	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(16专业)",
378	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(17专业)",
379	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(18专业)",
380	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(19专业)",
381	=>"（免费全科师范定向就业招生)(定向县(市)见专业说明)(20专业)",
382	=>"与商丘职业技术学院联办)(就读在商丘职业技术学院",
383	=>"与信阳职业技术学院联办)(就读在信阳职业技术学院",
384	=>"与南阳医学高等专科学校联办，就读在南阳医专",
385	=>"与俄罗斯人民友谊大学合办",
386	=>"与河南省人民检察院联办,就读在河南检察职业学院",
387	=>"与河南经贸职业学院联办，就读在河南经贸职业学院",
388	=>"与三门峡市政府联办应用工程学院，就读地在三门峡市",
389	=>"与嵩山少林武术职业学院联办,就读地详见专业说明",
390	=>"与漯河市政府合办漯河工学院，就读地在漯河",
391	=>"应用技术学院，各专业办学地点在济源市",
392	=>"应用科技学院，办学地点在开封",
393	=>"与俄罗斯人民友谊大学本科课程合作项目",
394	=>"与嵩山少林武术职业学院联合办学(前两年就读嵩山）",
395	=>"与商丘医学高等专科学校联办(就读在商丘医专）",
396	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(02专业)",
397	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(03专业)",
398	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(04专业)",
399	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(05专业)",
400	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(06专业)",
401	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(07专业)",
402	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(08专业)",
403	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(09专业)",
404	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(10专业)",
405	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(11专业)",
406	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(12专业)",
407	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(13专业)",
408	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(14专业)",
409	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(01专业)",
410	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(15专业)",
411	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(16专业)",
412	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(17专业)",
413	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(18专业)",
414	=>"免费全科师范定向就业招生)(定向县(市)见专业说明)(19专业)",
415	=>"与商丘职业技术学院联办(就读在商丘职业技术学院)",
416	=>"与信阳职业技术学院联办(就读在信阳职业技术学院)",
417	=>"与河南工业职业技术学院联办，就读地在南阳",
418	=>"与郑州信息科技职业学院联办",
419	=>"与平顶山工业职业技术学院联办，就读地在平顶山",
420	=>"与黄河水利职业技术学院联办，就读地在开封",
421	=>"与鹤壁市政府联办工程技术学院,就读在鹤壁",
422	=>"与漯河市政府合办漯河工学院,就读地在漯河",
423	=>"与河南应用技术职业学院联办，就读在技术职业学院",
424	=>"与河南职业技术学院联办，就读在河南职业技术学院",
425	=>"中外合作办学，较高收费",
426	=>"与河南机电职业学院联办,就读在河南机电职业学院",
427	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(01专业)",
428	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(02专业)",
429	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(03专业)",
430	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(04专业)",
431	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(05专业)",
432	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(06专业)",
433	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(07专业)",
434	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(08专业)",
435	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(09专业)",
436	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(10专业)",
437	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(11专业)",
438	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(12专业)",
439	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(13专业)",
440	=>"(免费全科师范定向就业招生)(定向县(市)见专业说明)(14专业)",
441	=>"外语单科成绩90分及以上",
442	=>"软件类专业",
443	=>"软件类（龙子湖校区）",
444	=>"办学就读地在焦作市解放中路",
445	=>"办学就读地点在河南辅读中等职业学校",
446	=>" 应用科技学院，办学地点在开封",
447	=>"中外合作办学,就读在象湖校区",
448	=>"中外合作办学,就读在龙子湖校区",
449	=>"与爱尔兰合办",
450	=>"办学地点在河南省民族中等专业学校",
451	=>"农村专项",
452	=>"班戈学院",
453	=>"汉族",
454	=>"非汉族",
455	=>"软件学院",
456	=>"中外合作办学专业",
457	=>"少数民族班",
458	=>"医学院",
459	=>"深圳市外",
460	=>"深圳市内",
461	=>"江门市外",
462	=>"江门市内",
463	=>"中山市外",
464	=>"中山市内",
465	=>"东莞市外",
466	=>"东莞市内",
467	=>"与广东轻工职业技术学院联合培养",
468	=>"与中山职业技术学院联合培养",
469	=>"与广州城建职业学院联合培养",
470	=>"与顺德职业技术学院联合培养",
471	=>"与广州番禺职业技术学院联合培养",
472	=>"粤台联合培养",
473	=>"与珠海城市职业技术学院联合培养",
474	=>"顺德区外",
475	=>"顺德区内",
476	=>"清远市外",
477	=>"清远市内",
478	=>"珠海市外",
479	=>"珠海市内",
480	=>"与BTEC合作办学",
481	=>"全省",
482	=>"中外合作办学专业）",
483	=>"只招少数民族聚居地的少数民族考生）",
484	=>"民族班",
485	=>"只招少数民族",
486	=>"珠海校区",
487	=>"农林类专业",
488	=>"医护类专业",
489	=>"民族班（珠海校区）",
490	=>"民汉双语",
491	=>"少数民族语言",
492	=>"闽台合作办学",
493	=>"鳝溪校区",
494	=>"阿里巴巴联合办学",
495	=>"恒大校区",
496	=>"丹寨万达校区",
497	=>"医学部",
498	=>"软件职业技术学院",
499	=>"（民族班）",
500	=>"合作办学)",
501	=>"民族班)",
502	=>"国际班)",
503	=>"在中卫市就读)",
504	=>"西藏定向",
505	=>"农学类",
506	=>"中外作合办学",
507	=>"技能型本科",
508	=>"国际实验班",
509	=>"中外合作及实验班",
510	=>"非西藏生源定藏就业",
511	=>"高等职业教育普通本科",
512	=>"少数民族语言文学专业",
513	=>"迪庆专项",
514	=>"中国少数民族语言文学专业",
515	=>"闽台合作项目",
516	=>"特有民族班",
517	=>"德宏师专",
518	=>"中外合作办学和闽台合作项目",
519	=>"应用技术学院",
520	=>"澜湄国际职业学院",
521	=>"非人口较少民族考生 ",
522	=>"软件学院、中燃工学院",
523	=>"中外合作办学酒店管理专业",
524	=>"西双版纳职业技术学院",
525	=>"香格里拉职业技术学院",
526	=>"只招女生",
527	=>"闽台合作",
528	=>"福清校区",
529	=>"国际课程教育项目",
530	=>"面向福州",
531	=>"面向厦门",
532	=>"闽台合作，面向厦门",
533	=>"国际教育课程项目",
534	=>"国际课程实验班",
535	=>"面向龙岩",
536	=>"面向宁德",
537	=>"面向莆田",
538	=>"面向泉州",
539	=>"面向三明",
540	=>"面向南平",
541	=>"明徳学院",
542	=>"国际课程项目",
543	=>"面向漳州",
544	=>"临床医学5+3一体化",
545	=>"地矿专业",
546	=>"护理类",
547	=>"医学类",
548	=>"中文合作",
549	=>"地矿相关专业",
550	=>"龙河校区",
551	=>"少数民族考生",
552	=>"蚌埠学院",
553	=>"四年一贯制",
554	=>"蚌埠校区",
555	=>"国家专项计划",
556	=>"中外合作（高收费）类",
557	=>"特殊专业",
558	=>"专项计划（面向十堰）",
559	=>"国家专项计划（少数民族）",
560	=>"国际专项计划",
561	=>"地方专项计划",
562	=>"免费医学生",
563	=>"中外合作(高收费)类",
564	=>"中外合作(高收费）类",
565	=>"省属院校(特殊专业）",
566	=>"少数民族预料班",
567	=>"中外合作（高费）类",
568	=>"（面向当地）",
569	=>"法商学院（烹饪与营养教育专业）",
570	=>"省属院校（特殊专业）",
571	=>"面向当地",
572	=>"边防子女预科班",
573	=>"中外合作高收费专业",
574	=>"法商学院烹饪与营养教育专业",
575	=>"精准扶贫专项计划",
576	=>"其它校区",
577	=>"旅游类",
578	=>"航海类",
579	=>"精准专项扶贫计划",
580	=>"医学校区",
581	=>"A+A",
582	=>"AA",
583	=>"AB",
584	=>"AB+",
585	=>"B+B",
586	=>"B+B+",
587	=>"BB",
588	=>"BC",
589	=>"CC",
590	=>"CD",
591	=>"DD",
592	=>"历史A，另一门B",
593	=>"历史A，另一门B+",
594	=>"历史B，另一门C",
595	=>"历史B+，另一门B",
596	=>"物理A，另一门B",
597	=>"物理A，另一门B+",
598	=>"物理B，另一门C",
599	=>"物理B+，另一门B",
600	=>"定向就业",
601	=>"苏区专项计划",
602	=>"专业志愿",
603	=>"院校特定要求",
604	=>"地方专项本科",
605	=>"面试要求",
606	=>"醴陵陶瓷学院",
607	=>"中外合作办学（班戈学院）",
608	=>"大兴校区",
609	=>"固安校区",
610	=>"沙河校区",
611	=>"龙洞校区",
612	=>"濂溪校区",
613	=>"旗山校区",
614	=>"浦口校区",
615	=>"凯里市校区",
616	=>"潍坊校区",
617	=>"嘉定校区",
618	=>"杭州校区",
619	=>"百安校区",
620	=>"经开校区",
621	=>"中外合作办学和国际课程",
622	=>"克拉玛依校区",
623	=>"杨林校区",
624	=>"中外合作办学和校际交流",
625	=>"联合培养",
626	=>"大庆校区",
627	=>"佛山顺德区内",
628	=>"佛山顺德区外",
629	=>"省内东莞市外",
630	=>"广东省外",
631	=>"坪山教学点",
632	=>"与深圳信息职业技术学院协同培养",
633	=>"二本定向",
634	=>"定向西藏",
635	=>"合作办学",
636	=>"讯飞英才班",
637	=>"地矿类",
638	=>"珠海校区（民族班）",
639	=>"增加计划顺录少数民族考生",
640	=>"国际班",
641	=>"在中卫市就读",
642	=>"联合办学专业",
643	=>"国际本科学术互认课程",
644	=>"对外合作办学专业",
645	=>"德宏师专办学点",
646	=>"医学英语",
647	=>"定向辽宁省气象局",
648	=>"中外合作办学（计算机类）",
649	=>"省高校专项计划",
650	=>"国际商学院",
651	=>"萨里国际学院",
652	=>"新华国际商学院",
653	=>"朝鲜语答卷",
654	=>"亚澳商学院",
655	=>"辽阳武圣校区",
656	=>"材料科学与工程",
657	=>"珲春校区",
658	=>"金融学专业",
659	=>"南昌校区",
660	=>"佳木斯校区",
661	=>"辽阳分校",
662	=>"制药工程",
663	=>"朝鲜族",
664	=>"蒙古族",
665	=>"中外联合培养",
666	=>"蒙语授课",
667	=>"萨利国际学院",
668	=>"招收加试蒙古语考生",
669	=>"朝鲜语答卷的朝鲜族",
670	=>"蒙古语答卷",
671	=>"本二少数民族考生",
672	=>"湖北理工(滨江校区）",
673	=>"高职院校联办本科湖北工业大学",
674	=>"高职院校联办本科武汉轻工大学",
675	=>"高职院校联办本科湖北工程学院",
676	=>"高职院校联办本科湖北医药学院",
677	=>"高职院校联办本科荆楚理工学院",
678	=>"高职院校联办本科湖北汽车工业学院",
679	=>"高职院校联办本科湖北师范大学",
680	=>"高职院校联办本科湖北理工学院",
681	=>"高职院校联办本科黄冈师范学院",
682	=>"高职院校联办本科湖北科技学院",
683	=>"高职院校联办本科武汉商学院",
684	=>"高职院校联办本科湖北文理学院",
685	=>"高职院校联办本科武汉",
686	=>"高职院校联办本科武汉生物工程学院",
687	=>"高职院校联办本科武汉东湖学院",
688	=>"培准扶贫专项计划",
689	=>"知行学院(生物及食品）",
690	=>"法商学院(烹饪与营养教育）",
691	=>"湖北二师(学前教育）",
692	=>"麵於",
693	=>"北大医学部(医学英语)",
694	=>"华中科大(法医学类）",
695	=>"西安交大(理科试验班）",
696	=>"西安交大(医学试验）",
697	=>"普通",
698	=>"地方专项汁划",
699	=>"家专项计划(少数民族）",
700	=>"中外合作",
701	=>"临床医学",
702	=>"护理学",
703	=>"护理专业",
704	=>"高端技能型本科",
705	=>"动植物专业",
706	=>"峨眉校区就读",
707	=>"中外合作办学峨眉校区就读",
708	=>"农学",
709	=>"S13全科教师0318嵩县",
710	=>"S14全科教师0312孟津县",
711	=>"S15全科教师0311偃师市",
712	=>"S16全科教师0316宜阳县",
713	=>"S17全科教师0314伊川县",
714	=>"S18全科教师0315汝阳县",
715	=>"S19全科教师0399高新区",
716	=>"S20全科教师0398伊滨区",
717	=>"S21全科教师0317落宁县",
718	=>"S22全科教师0313新安县",
719	=>"S23全科教师0319栾川县",
720	=>"中外合作办学（医护类）",
721	=>"S14全科教师1614新县",
722	=>"S15全科教师1612罗山县",
723	=>"S16全科教师1613光山县",
724	=>"S17全科教师1619息县",
725	=>"S18全科教师1618淮滨县",
726	=>"S19全科教师16i6潢川县",
727	=>"S20全科教师1615商城县",
728	=>"S06全科教师1718唐河县",
729	=>"S07全科教师1715淅川县",
730	=>"S08全科教师1721方城县",
731	=>"软件类（较高收费）",
732	=>"S21全科教师1115襄城县",
733	=>"S22全科教师1114禹州市",
734	=>"S23全科教师1112鄢陵县",
735	=>"（免费全科师范定向就业招生)定向县(市)见专业说明）（S24全科教师1113长葛市）",
736	=>"S01全科教师0715内黄县",
737	=>"S02全科教师0712林州市",
738	=>"S03全科教师1516汝南县",
739	=>"S04全科教师0711安阳县",
740	=>"S05全科教师1519正阳县",
741	=>"S06全科教师1515上蔡县",
742	=>"S07全科教师1513遂平县",
743	=>"S08全科教师1512泌阳县",
744	=>"S09全科教师0912淇县",
745	=>"S10全科教师0911浚县",
746	=>"S11全科教师0514获嘉县",
747	=>"S12全科教师0517封丘县",
748	=>"S13全科教师0515延津县",
749	=>"S14全科教师0516原阳县",
750	=>"S15全科教师0812清丰县",
751	=>"S16全科教师0811濮阳县",
752	=>"S17全科教师0813南乐县",
753	=>"S18全科教师0814范县",
754	=>"S19全科教师1414太康县",
755	=>"S20全科教师0815台前县",
756	=>"S21全科教师1412西华县",
757	=>"S22全科教师1413扶沟县",
758	=>"S23全科教师1411商水县",
759	=>"S24全科教师1417沈丘县",
760	=>"S25全科教师1416郸城县",
761	=>"S26全科教师1418项城市",
762	=>"S27全科教师1419淮阳县",
763	=>"S28全科教师0214杞县",
764	=>"S29全科教师0412鲁山县",
765	=>"S30全科教师0411叶县",
766	=>"S31全科教师0615温县",
767	=>"S32全科教师0410舞钢市",
768	=>"S33全科教师0415郏县",
769	=>"S34全科教师0613武陟县",
770	=>"S35全科教师0611修武县",
771	=>"S36全科教师1316睢县",
772	=>"S37全科教师1314柘城县",
773	=>"S38全科教师1317民权县",
774	=>"S39全科教师1313虞城县",
775	=>"S40全科教师1212舞阳县",
776	=>"S41全科教师2501邓州市",
777	=>"S42全科教师1213临颍县",
778	=>"S43全科教师2901滑县",
779	=>"S44全科教师3101新蔡县",
780	=>"S45全科教师2401固始县",
781	=>"S46全科教师2701汝州市",
782	=>"S47全科教师2801长垣县",
783	=>"S48全科教师2301永城市",
784	=>"S49全科教师2601兰考县",
785	=>"S50全科教师3001鹿邑县",
786	=>"S14全科教师0398伊滨区",
787	=>"S15全科教师0317洛宁县",
788	=>"S16全科教师0311偃师市",
789	=>"S17全科教师0319栾川县",
790	=>"S18全科教师0313新安县",
791	=>"S19全科教师0315汝阳县",
792	=>"S20全科教师0316宜阳县",
793	=>"S21全科教师0314伊川县",
794	=>"S22全科教师0312孟津县",
795	=>"S23全科教师0399高新区",
796	=>"S19全科教师1616潢川县",
797	=>"S06全科教师1715淅川县",
798	=>"S07全科教师1718唐河县",
799	=>"S24全科教师1113长葛市",
800	=>"S25全科教师1U5襄城县",
801	=>"SOI全科教师0715内黄县",
802	=>"S02全科教师0711安阳县",
803	=>"S03全科教师0712林州市",
804	=>"S04全科教师1516汝南县",
805	=>"S05全科教师1512泌阳县",
806	=>"S06全科教师1519正阳县",
807	=>"S07全科教师1515上蔡县",
808	=>"S08全科教师1513遂平县",
809	=>"S09全科教师0911浚县",
810	=>"S10全科教师0514获嘉县",
811	=>"S11全科教师0912淇县",
812	=>"S12全科教师0515延津县",
813	=>"S13全科教师0517封丘县",
814	=>"S14全科教师0811濮阳县",
815	=>"S15全科教师0516原阳县",
816	=>"S16全科教师0812清丰县",
817	=>"S19全科教师0815台前县",
818	=>"S20全科教师1412西华县",
819	=>"S21全科教师1411商水县",
820	=>"S22全科教师1414太康县",
821	=>"S23全科教师1416郸城县",
822	=>"S25全科教师1413扶沟县",
823	=>"S31全科教师0410舞钢市",
824	=>"S32全科教师0415郏县",
825	=>"S33全科教师0615温县",
826	=>"S36全科教师1314柘城县",
827	=>"S37全科教师1317民权县",
828	=>"S38全科教师1316睢县",
829	=>"S40全科教师2501邓州市",
830	=>"S41全科教师1213临颍县",
831	=>"S42全科教师1212舞阳县",
832	=>"S43全科教师2401固始县",
833	=>"S44全科教师2901滑县",
834	=>"S45全科教师2701汝州市",
835	=>"S46全科教师3101新蔡县",
836	=>"S47全科教师2601兰考县",
837	=>"S49全科教师2801长垣县",
838	=>"全科教师栾川县",
839	=>"全科教师新安县",
840	=>"全科教师偃师市",
841	=>"全科教师宜阳县",
842	=>"全科教师汝阳县",
843	=>"全科教师洛宁县",
844	=>"全科教师卢氏县",
845	=>"全科教师嵩县",
846	=>"全科教师灵宝市",
847	=>"全科教师伊川县",
848	=>"全科教师汝州市",
849	=>"全科教师盂津县",
850	=>"马来西亚城市大学河洛学院",
851	=>"全科教师林州市",
852	=>"全科教师濮阳县",
853	=>"全科教师清丰县",
854	=>"全科教师浚县",
855	=>"全科教师淇县",
856	=>"全科教师原阳县",
857	=>"全科教师封丘县",
858	=>"全科教师内黄县",
859	=>"全科教师汤阴县",
860	=>"全科教师安阳县",
861	=>"全科教师辉县市",
862	=>"全科教师获嘉县",
863	=>"全科教师延津县",
864	=>"全科教师南乐县",
865	=>"全科教师范县",
866	=>"全科教师台前县",
867	=>"（与商丘职业技术学院联办）（就读在商丘职业技术学院）",
868	=>"全科教师宁陵县",
869	=>"全科教师睢县",
870	=>"全科教师虞城县",
871	=>"全科教师民权县",
872	=>"全科教师柘城县",
873	=>"全科教师叶县",
874	=>"全科教师宝丰县",
875	=>"全科教师鲁山县",
876	=>"全科教师舞钢市",
877	=>"全科教师郏县",
878	=>"全科教师西华县",
879	=>"全科教师沈丘县",
880	=>"全科教师扶沟县",
881	=>"全科教师淮阳县",
882	=>"全科教师太康县",
883	=>"全科教师商水县",
884	=>"全科教师郸城县",
885	=>"全科教师项城市",
886	=>"全科教师兰考县",
887	=>"全科教师新县",
888	=>"全科教师罗山县",
889	=>"全科教师光山县",
890	=>"全科教师息县",
891	=>"全科教师淮滨县",
892	=>"全科教师潢川县",
893	=>"全科教师商城县",
894	=>"全科教师汝南县",
895	=>"全科教师上蔡县",
896	=>"全科教师确山县",
897	=>"全科教师遂平县",
898	=>"全科教师正阳县",
899	=>"（免费全科师范定向就业招生)定向县(市)见专业说明〉（全科教师泌阳县）",
900	=>"全科教师方城县",
901	=>"全科教师淅川县",
902	=>"全科教师邓州市",
903	=>"全科教师济源市",
904	=>"全科教师唐河县",
905	=>"与漯河市政府合办漯河工学院（就读地在漯河）",
906	=>"全科教师新蔡县",
907	=>"全科教师鹿邑县",
908	=>"（免费全科师范定向就业招生)定向县(市)见专业说明）（全科教师固始县）",
909	=>"全科教师滑县",
910	=>"全科教师永城市",
911	=>"全科教师长垣县",
912	=>"全科教师巩义市",
913	=>"全科教师温县",
914	=>"全科教师武陟县",
915	=>"全科教师博爱县",
916	=>"全科教师盂州市",
917	=>"全科教师沁阳市",
918	=>"全科教师临颍县",
919	=>"全科教师舞阳县",
920	=>"全科教师杞县",
921	=>"全科教师中牟县",
922	=>"全科教师襄城县",
923	=>"全科教师鄢陵县",
924	=>"全科教师长葛市",
925	=>"全科教师禹州市",
926	=>"与商丘职业技术学院联办（就读在商丘职业技术学院）",
927	=>"全科教师泌阳县",
928	=>"与南阳医学髙等专科学校联办，就读在南阳医专",
929	=>"与河南工业职业技术学院联办，就读地在南阳市",
930	=>"与鹤壁市政府联办工程技术学院（就读在鹤壁）",
931	=>"与济源职业技术学院联办（就读在济源职业技术学院）",
932	=>"全科教师固始县",
933	=>"全科教师修武县",
934	=>"乌拉尔学院",
935	=>"工程学院",
936	=>"与开封大学联合办学就读地点：开封大学",
937	=>"中原彼得堡航空学院",
938	=>"园艺技术专业",
939	=>"分段培养",
940	=>"办学地点在开封",
941	=>"各专业办学地点在济源市",
968	=>"红河定向",
969	=>"少数民族计划",
970	=>"医学护理类",
971	=>"中外合作办学物流工程专业",
972	=>"定向专业",
973	=>"预科",
974	=>"怒江专项预科",
975	=>"迪庆专项预科",
976	=>"人口较少民族预科",
977	=>"预科定向",
978	=>"医学类预科",
979	=>"高等职业教育普通本科预科",
980	=>"高职本科",
981	=>"高职联合培养",
982	=>"只招男生",
983	=>"艺术类专业",
984	=>"面向厦门，闽台合作",
985	=>"高山族",
986	=>"市内",
987	=>"市外",
988	=>"协同培养",
989	=>"区内",
990	=>"区外",
991	=>"精准扶贫",
992	=>"应用型本科",
993	=>"南宁空港校区",
994	=>"防城港校区",
995	=>"玉林校区",
996	=>"南宁空港校区精准扶贫",
997	=>"南宁空港校区民族班",
998	=>"精准脱贫",
999	=>"121项目",
        ];

        return $type[$num] ?? "";

    }
}
