<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to the "home" route for your application.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/home';

    protected $namespace = "App\Http\Controllers";

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     *
     * @return void
     */
    public function boot()
    {
        $this->configureRateLimiting();

        $this->routes(function () {
            Route::middleware('web')
                ->group(base_path('routes/web.php'));
        });

        $this->registerCourseRoute();
        $this->registerApiRoute();
        $this->registerOrderRoute();
        $this->registerFileRoute();
        $this->registerLoginRoute();
        $this->registerAccountRoute();
        $this->registerVideoRoute();
        $this->registerCategoryRoute();
    }

    protected function registerCourseRoute()
    {
        Route::middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/course.php'));
    }
    protected function registerApiRoute()
    {
        Route::middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/api.php'));
    }

    protected function registerOrderRoute()
    {
        Route::middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/order.php'));
    }

    protected function registerFileRoute()
    {
        Route::middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/file.php'));
    }

    /**
     * 登录,注册
     */
    protected function registerLoginRoute()
    {
        Route::middleware('login')
            ->namespace($this->namespace)
            ->group(base_path('routes/login.php'));
    }

    /**
     * 账户
     */
    protected function registerAccountRoute()
    {
        Route::middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/account.php'));
    }

    /**
     * 视频
     */
    protected function registerVideoRoute()
    {
        Route::middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/video.php'));
    }

    /**
     * 视频
     */
    protected function registerCategoryRoute()
    {
        Route::middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/category.php'));
    }

    /**
     * Configure the rate limiters for the application.
     *
     * @return void
     */
    protected function configureRateLimiting()
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });
    }
}
