<?php

namespace App\Models;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Base
{
    //表名声明
    protected $table = 'yh_order';
    use SoftDeletes;

    //主键声明
    protected $primaryKey = 'id';
    protected $dates = ['deleted_at'];

    public function getList($where = [], $field = [], $pagesize = 10, $order = 'id', $sort = 'DESC',$orderWhereIn)
    {
        if (empty($order)) {
            $order = $this->primaryKey;
        }
        if(count($orderWhereIn)>0){
            $data = $this->where($where);
            foreach($orderWhereIn as $k=>$v){
               $data= $data ->whereIn($k,$v);
            }
            $data= $data->select($field)
            ->orderBy($order, $sort)
            ->paginate($pagesize);
        }else{
            $data = $this->where($where)
            ->select($field)
            ->orderBy($order, $sort)
            ->paginate($pagesize);
        }
        


        if (empty($data)) {
            return [];
        } else {
            return $data->toArray();
        }
    }
}
