<?php

namespace App\Models;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class Course extends Base
{
    //表名声明
    protected $table = 'yh_course';
    use SoftDeletes;

    //主键声明
    protected $primaryKey = 'id';
    protected $dates = ['deleted_at'];

    public function selectDataWithPageAndComplexCondition($where = [], $status = [], $field = [], $pagesize = 10)
    {
        if (empty($order)) {
            $order = $this->primaryKey;
        }

//        DB::enableQueryLog();

        $courseListSelect = $this->where($where);

        if (!empty($status)) {
            $courseListSelect = $courseListSelect->whereIn('status', $status);
        }

        $data = $courseListSelect->select($field)
            ->orderBy('is_top', 'desc')
            ->orderBy('set_top_time', 'desc')
            ->orderBy('sort', 'desc')
            ->orderBy('id', 'desc')
            ->paginate($pagesize);

//        var_dump(DB::getQueryLog());die;

        if (empty($data)) {
            return [];
        } else {
            return $data->toArray();
        }
    }

}
