<?php

namespace App\Http\Services;

use App\Models\Student;
use App\Models\StudentEval;
use App\Models\StudentConsult;
use App\Models\Log;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;

class BannerService extends BaseService
{

    public function listService($phone, $useraNme, $pageId, $pageSize = 20) {


        $search = [
            ['id','>',0]
        ]; // 拼接搜索条件
        if (!empty($phone)) {
            $search[] = ['phone', 'like', '%' . $phone . '%'];
        }
        if (!empty($useraNme)) {
            $search[] = ['name', 'like', '%' . $useraNme . '%'];
        }

        $student= new Student();
        $count = $student->selectinfoForPaginateCount($search);
        $list = $student->selectinfoForPaginate($search, ['*'], ($pageId - 1) * $pageSize,  $pageSize );

        return ['code'=>0, 'msg'=>'success', 'data'=>['list'=>$list, 'page_id'=>$pageId, 'count'=>$count]];

    }
    public function infoService($id) {

        $search = [
            ['id','=',$id]
        ]; // 拼接搜索条件
        $student= new Student();
        $list = $student->findData($search);

        return ['code'=>0, 'msg'=>'success', 'data'=>$list];
    }

    public function deleteService($id, $userInfo) {

        $search = [
            ['id','=',$id]
        ]; // 拼接搜索条件
        $student= new Student();
        $list = $student->findData($search);
        if(empty($list)){
            return ['code'=>10001, 'msg'=>'不存在的信息', 'data'=>[]];
        }
        $student->deleteData($search);

        (new Log())->insertData(['operator' => $userInfo['id'] ?? 0, 'url' => '删除学员', 'type' => 3, 'content' => json_encode(['id' => $id])]);

        return ['code'=>0, 'msg'=>'success', 'data'=>[]];
    }

    public function editService($id,$updateData, $userInfo) {

        $student= new Student();
        $student->updateData(['id'=>$id], $updateData);

        $list = $student->findData(['id'=>$id]);

        (new Log())->insertData(['operator' => $userInfo['id'] ?? 0, 'url' => '编辑学员', 'type' => 2, 'content' => json_encode(['updateData' => $updateData])]);

        return ['code'=>0, 'msg'=>'success', 'data'=>$list];
    }

    public function evalLstService($phone, $useraNme, $pageId, $pageSize = 20) {


        $search = [
            ['id','>',0]
        ]; // 拼接搜索条件
        if (!empty($phone)) {
            $search[] = ['phone', 'like', '%' . $phone . '%'];
        }
        if (!empty($useraNme)) {
            $search[] = ['user_name', 'like', '%' . $useraNme . '%'];
        }

        $studentEval= new StudentEval();
        $count = $studentEval->selectinfoForPaginateCount($search);
        $list = $studentEval->selectinfoForPaginate($search, ['*'], ($pageId - 1) * $pageSize,  $pageSize );

        return ['code'=>0, 'msg'=>'success', 'data'=>['list'=>$list, 'page_id'=>$pageId, 'count'=>$count]];

    }

    public function consultLstService($phone, $useraNme, $pageId, $pageSize = 20) {

        $search = [
            ['id','>',0]
        ]; // 拼接搜索条件
        if (!empty($phone)) {
            $search[] = ['phone', 'like', '%' . $phone . '%'];
        }
        if (!empty($useraNme)) {
            $search[] = ['user_name', 'like', '%' . $useraNme . '%'];
        }

        $studentConsult= new StudentConsult();
        $count = $studentConsult->selectinfoForPaginateCount($search);
        $list = $studentConsult->selectinfoForPaginate($search, ['*'], ($pageId - 1) * $pageSize,  $pageSize );

        return ['code'=>0, 'msg'=>'success', 'data'=>['list'=>$list, 'page_id'=>$pageId, 'count'=>$count]];

    }





}
