<?php

namespace App\Http\Services;

use App\Models\AdminUserModel;

class AdminUserService extends BaseService
{

    private $model;

    public function __construct()
    {
        $this->model = new AdminUserModel();
    }
    public function getList($search_data)
    {
        $search = [
            ['id','>',0]
        ]; // 拼接搜索条件
        if (isset($search_data['phone']) && !empty($search_data['phone'])) {
            $search[] = ['phone', 'like', '%' . $search_data['phone'] . '%'];
        }
        if (!isset($search_data['user_name']) || strlen($search_data['user_name']) >= 0) {
            $search[] = ['user_name', 'like', '%' . $search_data['user_name'] . '%'];
        }
        try {
            $Res = $this->model->selectDataWithField($search, ['id','phone','user_name','pwd','status']);
            return ['code' => 0, 'msg' => 'success', 'data' => $Res];
        } catch (\Exception $e) {
            return ['code' => 1, 'msg' => $e->getMessage()];
        }
    }

    //查询详情
    public function getInfo($id)
    {
        try {
            $Res = $this->model->findDataWithField(['id' => $id], "*");
            if ($Res) {
                return ['code' => 0, 'msg' => 'success', 'data' => $Res];
            } else {
                return ['code' => 1, 'msg' => '账号不存在'];
            }
        } catch (\Exception $e) {
            return ['code' => 1, 'msg' => $e->getMessage()];
        }
    }

    //删除
    public function Del($data)
    {
        try {
            $Res = $this->model->deleteData($data);
            if ($Res == 1) {
                return ['code' => 0, 'msg' => 'success'];
            } else {
                return ['code' => 1, 'msg' => '删除失败'];
            }
        } catch (\Exception $e) {
            return ['code' => 1, 'msg' => $e->getMessage()];
        }
    }
    // 校验重复
    public function checkRepeat($phone)
    {
        $where [] =  ['deleted_at','=',null];
        $where [] =  ['phone','=',$phone];

        $Res = $this->model->getCountByWhere( $where);
        return $Res >0;
    }
    //添加
    public function Add($data)
    {
        try{
            $Res = $this->model->insertData($data);
            if($Res){
                return ['code' => 0, 'msg' => 'success', 'data' => $Res];
            }else{
                return ['code' => 1, 'msg' => 'error'];
            }
        }catch (\Exception $e) {
            return ['code' => 1, 'msg' => $e->getMessage()];
        }
      
    }
    //添加
    public function Edit($data)
    {
        $update_data = [];
        $where_data = [];

        $Res = $this->model->findDataWithField(['id' => $data['id']], "*");
        if (!$Res) {
            return ['code' => 1, 'msg' => '账号不存在'];
        }
        $where_data['id'] = $data['id'];
        if(strlen($data['phone'])>0 && $Res['phone'] != $data['phone'] ){
            $Res1 = $this->model->selectDataWithField(['phone' => $data['phone'], ['id', '<>', $data['id']]], "*");
            if (count($Res1) > 0) {
                return ['code' => 1, 'msg' => '手机号 重复：' . $data['phone'], 'c' => count($Res)];
            } else {
                $update_data['phone'] = $data['phone'];
            }
        }
        if(strlen($data['pwd'])>0 && $Res['pwd'] != $data['pwd'] ){ 
            $update_data['pwd'] = $data['pwd'];// md5 
        }

        if(strlen($data['user_name'])>0 && $Res['user_name'] != $data['user_name'] ){ 
            $update_data['user_name'] = $data['user_name'];
        }
        if(strlen($data['status'])>0 && $Res['status'] != $data['status'] ){ 
            $update_data['status'] = $data['status'];
        }
    
        try{
            $Res1 = $this->model->updateData($where_data, $update_data);
            if ($Res1) {
                return ['code' => 0, 'msg' => 'success', 'update_data' => $update_data];
            } else {
                return ['code' => 1, 'msg' => '修改失败', 'update_data' => $update_data];
            }
        }catch (\Exception $e) {
            return ['code' => 1, 'msg' => $e->getMessage()];
        }
      
    }
}
