<?php
/**
 * Created by PhpStorm.
 * User: bmb369
 * Date: 2024-05-07
 * Time: 16:01
 */
namespace App\Http\Services;

use App\Models\AddrModel;
use App\Models\OrderExpressModel;
use App\Models\AreaProvinceModel;
use App\Models\AreaCityModel;
use App\Models\AreaCountyModel;
use Illuminate\Support\Facades\Log;

// class EmptyObject {}
class AddrService{



    public function getPAndCDataService(){


        $proModel = new AreaProvinceModel();
        $cityModel = new AreaCityModel();
        $reaCountyModel = new AreaCountyModel();
        $provinceFindRet = $proModel->selectinfo(['p_code'=>1],['name','area_code','p_code']);
        $where = [
            ['id', '>=', 1],
        ];
        $cityFindRet = $cityModel->selectinfo($where, ['name','area_code','p_code']);
        $countyFindRet = $reaCountyModel->selectinfo($where, ['name','area_code','p_code']);
        $countyList = [];
        foreach ($countyFindRet as $key => $value) {
            $value['level'] = 4;
            $value['child'] = [];
            $countyList[$value['p_code']][] = $value;
        }

        //市
        $cityList = [];
        foreach ($cityFindRet as $key => $value) {
            $value['level'] = 3;
            $value['child'] = $countyList[$value['area_code']] ?? [];
            $cityList[$value['p_code']][] = $value;
        }

        //省
        $provinceLst = [];
        foreach ($provinceFindRet as $index=>$item){
            $provinceLst[] =[
                'name' => $item['name'],
                'level' => 2,
                'area_code' => $item['area_code'],
                'p_code' => $item['p_code'],
                'child' => $cityList[$item['area_code']] ?? [],
            ];
        }

        return ['code'=>0, 'msg'=>'success','data'=>['list' => $provinceLst]];

    }
    public function getListCityService(){

        $proModel = new AreaProvinceModel();
        $provinceFindRet = $proModel->selectinfo(['p_code'=>1],['name','area_code','p_code']);
        return ['code'=>0, 'msg'=>'success','data'=>$provinceFindRet];
        
    }
    public function getListCityUserService($area_pro){
        
        $proModel = new AreaProvinceModel();
        $where[] = ['p_code', '=', 1];
        $wherein_area_code =  explode(',',$area_pro);
        $provinceFindRet = $proModel->selectinfo2($where,$wherein_area_code,['name','area_code','p_code']);
        return ['code'=>0, 'msg'=>'success','data'=>$provinceFindRet];

    }



    //添加收货地址
    public function addAddr($userid,$phone_code,$phone,$person,$country,$country_name,
        $p_code,$p_name,$c_code,$c_name,$area_code,$area_name,$t_code,$t_name,$address, $isDefault){
        $model = new AddrModel();
        $where['user_id'] = $userid;
        $count = $model->getCountByWhere($where);
        
        if($count>=20){
            $result = [
                'code' => 10002,
                'msg' => '一个用户最多可以设置20个地址',
                'data' => new \ArrayObject()
            ];
            return $result;
        }
        
        $data['user_id'] = $userid;
        $data['phone_code'] = $phone_code;
        $data['phone'] = $phone;
        $data['person'] = $person;
        $data['country'] = $country;
        $data['country_name'] = $country_name;
        $data['p_code'] = $p_code;
        $data['p_name'] = $p_name;
        $data['c_code'] = $c_code;
        $data['c_name'] = $c_name;
        $data['area_code'] = $area_code;
        $data['area_name'] = $area_name;
        $data['t_code'] = $t_code;
        $data['t_name'] = $t_name;
        $data['address'] = $address;

        if($isDefault == 1){
            $data['def_add'] = 1;
            $model->updateData(['user_id' => $userid], ['def_add' => 0]);
        }

        $info = $model->insertData($data);
        
        if(empty($info)){
            $result = [
                'code' => 10001,
                'msg' => '添加失败',
                'data' => new \ArrayObject()
            ];
            return $result;
        }
        
        
        $result = [
            'code' => 0,
            'msg' => '添加成功',
            'data' => new \ArrayObject()
        ];
        
        return $result;
    }

    //添加收货地址
    public function editAddr($id,$userid,$phone_code,$phone,$person,$country,$country_name,
        $p_code,$p_name,$c_code,$c_name,$area_code,$area_name,$t_code,$t_name,$address, $isDefault){
        $model = new AddrModel();
        $where['user_id'] = $userid;
        $where['id'] = $id;
        $count = $model->getCountByWhere($where);

        if($count == 0){
            $result = [
                'code' => 10002,
                'msg' => '不存在的地址',
                'data' => []
            ];
            return $result;
        }

        $data['phone_code'] = $phone_code;
        $data['phone'] = $phone;
        $data['person'] = $person;
        $data['country'] = $country;
        $data['country_name'] = $country_name;
        $data['p_code'] = $p_code;
        $data['p_name'] = $p_name;
        $data['c_code'] = $c_code;
        $data['c_name'] = $c_name;
        $data['area_code'] = $area_code;
        $data['area_name'] = $area_name;
        $data['t_code'] = $t_code;
        $data['t_name'] = $t_name;
        $data['address'] = $address;

        if($isDefault == 1){
            $data['def_add'] = 1;
            $model->updateData(['user_id' => $userid], ['def_add' => 0]);
        }

        $info = $model->updateData($where, $data);

        if(empty($info)){
            $result = [
                'code' => 10001,
                'msg' => '添加失败',
                'data' => []
            ];
            return $result;
        }


        $result = [
            'code' => 0,
            'msg' => '添加成功',
            'data' =>[]
        ];

        return $result;
    }

    //获取收货地址
    public function getAddr($userid){
        $model = new AddrModel();
        $where['user_id'] = $userid;//用户id
        
        $field = ['id', 'user_id', 'phone_code', 'phone',
            'person', 'country','country_name', 'p_code', 'p_name','c_code', 'c_name','area_code','area_name','t_code','t_name','address','def_add'];
        $info = $model->selectDataWithField($where,$field, 'def_add', "DESC");
        
        if(empty($info)){
            $result = [
                'code' => 0,
                'msg' => '还没有添加收货地址',
                'data' => []
            ];
            return $result;
        }
        $result = [
            'code' => 0,
            'msg' => '获取成功',
            'data' => $info
        ];
        return $result;
    }

    //删除某个地址
    public function delAddr($userid,$id){
        $model = new AddrModel();
        
        $where['user_id'] = $userid;//用户id
        $where['id'] = $id;//地址id
        
        $info = $model->deleteData($where);
        
        if($info<=0){
            $result = [
                'code' => 10001,
                'msg' => '删除失败',
                'data' => []
            ];
            return $result;
        }
        $result = [
            'code' => 0,
            'msg' => '删除成功',
            'data' => []
        ];
        return $result;
    }
    
    //删除某个地址
    public function setAddr($userid,$id){
        $model = new AddrModel();
        
        $where['user_id'] = $userid;//用户id
//         
        $updateDate['def_add'] = 0;
        $model->updateData($where,$updateDate);
        $where['id'] = $id;//地址id
        $updateDate['def_add'] = 1;
        $info = $model->updateData($where,$updateDate);
        
        if($info<=0){
            $result = [
                'code' => 10001,
                'msg' => '设置失败',
                'data' => []
            ];
            return $result;
        }
        $result = [
            'code' => 0,
            'msg' => '设置成功',
            'data' => []
        ];
        return $result;
    }

}
