<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class FileAuth
{
    // 是否启用调试模式
    protected $debug = false;

    // 请求有效期
    protected static $allowedRequestTimeInterval = 10;

    public function handle(Request $request, Closure $next)
    {
        if ($request->header('debug') == "pass") {
            return $next($request);
        }

        $requestTime = (int)($request->input('request_time', '0'));
        $currentTime = time();
        $timeInterval = $currentTime - $requestTime;

        // 3s的前置时间冗余
//        if ($timeInterval < -3 || $timeInterval > self::$allowedRequestTimeInterval) {
//            return response()->json(['code' => 50010, 'msg' => '请求已失效,请重新发起请求',
//                'request' => [
//                    'request_time' => $requestTime,
//                    'current_time' => $currentTime,
//                    'time_interval' => $timeInterval,
//                    'allowed_time_interval' => self::$allowedRequestTimeInterval,
//                ]
//            ]);
//        }

        return $next($request);
    }

}
