<?php

namespace App\Http\Controllers;
use App\Lib\Captcha;
use Illuminate\Http\Request;
use App\Http\Services\LoginService;
use Illuminate\Support\Facades\Storage;
use App\Exceptions\Constants;

class LoginController extends BaseController
{
    //数据处理层初始化
    protected $loginService;

    /**
     * 构造方法,初始化service
     * @access public
     * @param Request $request Request 对象
     */
    public function __construct() {
        $this->loginService = new LoginService();
    }


    //小程序登录
    public function getWxLogin(Request $request){
        $code = $request->get('js_code', ""); //
        $platform = $request->get('platform', ""); //
        if(empty($code)){
            return $this->respondError(10001, 'js_code码异常');
        }
        $data =  $this->loginService->getWxLoginService($code, $platform);
        return $this->respond($data);
    }

    public function getWxPhone(Request $request){
        $code = $request->get('code', ""); //
        $openid = $request->get('openid', ""); //
        $platform = $request->get('platform', ""); //
        $owner = $request->get('owner', ""); //
        if(empty($code)){
            return $this->respondError(10001, 'code码异常');
        }
        if(empty($openid)){
            return $this->respondError(10001, 'opneid码异常');
        }
//        if(empty($nickName)){
//            return $this->respondError(10001, '昵称不能为空');
//        }

        $data = $this->loginService->getWxPhoneService($code , $openid, $platform, $owner);
        return $this->respond($data);
    }


    /**
     * 登录
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function login(Request $request)
    {
        $phone = $request->post('phone', '');
        $passwd = $request->post('pwd', '');
        if (empty($passwd)) {
            return $this->respondError(10001, '密码不能为空');
        }
        if (empty($phone) || false == checkPhone($phone)) {
            return $this->respondError(10001, '请输入正确的手机号');
        }

        //web后台登录
        $result = $this->loginService->loginHandle($phone, $passwd, 'web');
        return $this->respond($result);
    }

    //基本信息
    public function studentInfoSubmit(Request $request){
        $name = $request->post('user_name', '');
        $phone = $request->post('phone', '');
        $baseInfo = $request->post('base_info', '');
        if (empty($phone) || false == checkPhone($phone)) {
            return $this->respondError(10001, '请输入正确的手机号');
        }
        if (empty($name) || mb_strlen($name) > 20 ) {
            return $this->respondError(10001, '请输入正确的姓名');
        }
        if (empty($baseInfo) || false == json_decode($baseInfo, true)) {
            return $this->respondError(10001, '请填报正确的信息');
        }

        $result = $this->loginService->studentInfoSubmitService($name, $phone, $baseInfo);
        return $this->respond($result);

    }

    //意向信息
    public function studentIntentionInfoSubmit(Request $request){
        $id = $request->post('id', '');
        $intentionInfo = $request->post('intention_info', '');
        if (empty($id)) {
            return $this->respondError(10001, '参数异常');
        }
        if (empty($intentionInfo) || false == json_decode($intentionInfo, true)) {
            return $this->respondError(10001, '请填入正确的信息');
        }

        $result = $this->loginService->studentIntentionInfoSubmitService($id, $intentionInfo);
        return $this->respond($result);

    }
    //成绩
    public function studentScoreInfoSubmit(Request $request){
        $id = $request->post('id', '');
        $scoreInfo = $request->post('score_info', '');
        if (empty($id)) {
            return $this->respondError(10001, '参数异常');
        }
        if (empty($scoreInfo) || false == json_decode($scoreInfo, true)) {
            return $this->respondError(10001, '请填入正确的信息');
        }

        $result = $this->loginService->studentScoreInfoSubmitService($id, $scoreInfo);
        return $this->respond($result);

    }

    //评价
    public function studentEvalSubmit(Request $request){
        $name = $request->post('user_name', '');
        $phone = $request->post('phone', '');
        $weight = $request->post('weight_info', '');
        $evalInfo = $request->post('eval_info', '');
        if (empty($phone) || false == checkPhone($phone)) {
            return $this->respondError(10001, '请输入正确的手机号');
        }
        if (empty($name) || mb_strlen($name) > 20 ) {
            return $this->respondError(10001, '请输入正确的姓名');
        }
        if (empty($evalInfo) || false == json_decode($evalInfo, true)) {
            return $this->respondError(10001, '请填报正确的信息');
        }
        if (empty($weight) || false == json_decode($weight, true)) {
            return $this->respondError(10001, '请填正确的权重信息');
        }

        $result = $this->loginService->studentEvalSubmitService($name, $phone, $weight, $evalInfo);
        return $this->respond($result);

    }

    //咨询
    public function studentConsultSubmit(Request $request){
        $name = $request->post('user_name', '');
        $phone = $request->post('phone', '');
        $info = $request->post('info', '');
        $from = $request->post('from', '');
        if (empty($phone) || false == checkPhone($phone)) {
            return $this->respondError(10001, '请输入正确的手机号');
        }
        if (empty($name) || mb_strlen($name) > 20 ) {
            return $this->respondError(10001, '请输入正确的姓名');
        }
        if (empty($info) || false == json_decode($info, true)) {
            return $this->respondError(10001, '请填报正确的信息');
        }


        $result = $this->loginService->studentConsultSubmitService($name, $phone, $info,$from);
        return $this->respond($result);

    }

    /**
     * 2025普通类专业+院校 || 院校专业组 高考志愿预案表（姓名、手机号、省份、选科、分数、位次）
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function commonPreferenceMajor(Request $request) {
        $studentInfo = $request->json()->all();

        $checkResult = $this->loginService->checkCommonPreferenceMajorHandle($studentInfo);
        if (empty($checkResult['res'])) {
            return $this->respondError(30001, $checkResult['msg'] ?? '');
        }

        $result = $this->loginService->commonPreferenceMajorHandle($checkResult['data']);
        if (empty($result['res'])) {
            return $this->respondError(30002, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 家长报名意向填写
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function parentsIntentionPeriods(Request $request) {
        $result = $this->loginService->parentsIntentionPeriodsHandle();
        if (empty($result['res'])) {
            return $this->respondError(30002, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 家长报名意向填写
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function parentsIntention(Request $request) {
        $studentInfo = $request->json()->all();

        $checkResult = $this->loginService->checkParentsIntentionHandle($studentInfo);
        if (empty($checkResult['res'])) {
            return $this->respondError(30001, $checkResult['msg'] ?? '');
        }

        $result = $this->loginService->parentsIntentionHandle($checkResult['data']);
        if (empty($result['res'])) {
            return $this->respondError(30002, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }








}