<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Services\FileService;

class FileController extends BaseController
{
    //数据处理层初始化
    protected $fileService;

    /**
     * 构造方法,初始化service
     * @access public
     * @param Request $request Request 对象
     */
    public function __construct() {
        $this->fileService = new FileService();
    }

    public function getOssAccessToken() {
        $result = $this->fileService->getOssAccessTokenHandle();

        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }




}