<?php

use Illuminate\Support\Facades\Route;


// 课程管理
Route::group(['prefix'=> 'course'], function () {
    // 添加课程
    Route::post('add', ['uses' => 'CourseController@addCourse', 'label' => '课程管理', 'description' => '添加课程']);

    // 获取课程列表
    Route::get('list', ['uses' => 'CourseController@getCourseList', 'label' => '课程管理', 'description' => '获取课程列表']);

    // 修改课程发布状态
    Route::post('status', ['uses' => 'CourseController@updateCourseStatus', 'label' => '课程管理', 'description' => '课程发布']);

    // 删除课程(支持批量)
    Route::post('delete', ['uses' => 'CourseController@deleteCourse', 'label' => '课程管理', 'description' => '删除课程(支持批量)']);

    // 获取课程详情
    Route::get('info', ['uses' => 'CourseController@getCourseInfo', 'label' => '课程管理', 'description' => '编辑获取课程信息']);

    // 更新课程
    Route::post('update', ['uses' => 'CourseController@updateCourse', 'label' => '课程管理', 'description' => '更新课程']);

    // 推荐课程
    Route::post('recommend', ['uses' => 'CourseController@recommendCourse', 'label' => '课程管理', 'description' => '推荐课程']);

    // 置顶课程
    Route::post('top', ['uses' => 'CourseController@setCourseTop', 'label' => '课程管理', 'description' => '置顶课程']);

    // 获取课程实时库存
    Route::get('stock', ['uses' => 'CourseController@getCourseStock', 'label' => '课程管理', 'description' => '获取课程实时库存']);

    // 修改课程销量
    Route::post('sales', ['uses' => 'CourseController@updateCourseSales', 'label' => '课程管理', 'description' => '修改课程销量']);

});

// 课程评价
Route::group(['prefix'=> 'course/evaluate'], function () {
    // 小程序
    // 课程评价
    Route::post('add', ['uses' => 'CourseController@addCourseEvaluate', 'label' => '课程管理', 'description' => '课程评价']);

    // 获取课程评价列表
    Route::get('list', ['uses' => 'CourseController@getCourseEvaluateList', 'label' => '课程管理', 'description' => '获取课程评价列表']);

    // 后台
    // 获取课程评价列表
    Route::get('admin/list', ['uses' => 'CourseController@getCourseEvaluateAdminList', 'label' => '课程管理', 'description' => '获取课程评价列表']);

    // 获取评价详情
    Route::get('detail', ['uses' => 'CourseController@getCourseEvaluateDetail', 'label' => '课程管理', 'description' => '获取评价详情']);

    // 评价审核
    Route::post('check', ['uses' => 'CourseController@checkCourseEvaluate', 'label' => '课程管理', 'description' => '评价审核']);

});