#!/bin/bash

LOG_DIR="/data/cronlog"
# 创建日志目录（如果不存在）
mkdir -p "$LOG_DIR"

# crontab的日志文件
CRONTAB_LOG_FILE="$LOG_DIR/crontab.log"
NEW_CRONTAB_LOG_FILE="$LOG_DIR/crontab_$(date -d "1 days ago" +%Y-%m-%d).log"

# job的日志文件
JOB_LOG_FILE="$LOG_DIR/job.log"
NEW_JOB_LOG_FILE="$LOG_DIR/job_$(date -d "1 days ago" +%Y-%m-%d).log"

# 将当前日志文件重命名为昨天的日志文件 && 清空日志文件
cp "$CRONTAB_LOG_FILE" "$NEW_CRONTAB_LOG_FILE" && cat /dev/null > "$CRONTAB_LOG_FILE"

# 将当前日志文件重命名为昨天的日志文件 && 清空日志文件
cp "$JOB_LOG_FILE" "$NEW_JOB_LOG_FILE" && cat /dev/null > "$JOB_LOG_FILE"
