<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use App\Http\Services\CategoryService;

class CategoryController extends BaseController
{
    //数据处理层初始化
    protected $categoryService;

    /**
     * 构造方法,初始化service
     * @access public
     * @param Request $request Request 对象
     */
    public function __construct() {
        $this->categoryService = new CategoryService();
    }

    /**
     * 添加分类
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function addCategory(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $categoryInfo = $request->json()->all();

        $result = $this->categoryService->addCategoryHandle($userInfo, $categoryInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 上下架分类
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function pubCategory(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $categoryInfo = $request->json()->all();

        $result = $this->categoryService->pubCategoryHandle($userInfo, $categoryInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 获取分类列表
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getCategoryList(Request $request) {
        $platform = $request->input('platform', '');
        $result = $this->categoryService->getCategoryListHandle($platform);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 删除分类
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function deleteCategory(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $categoryInfo = $request->json()->all();

        $result = $this->categoryService->deleteCategoryHandle($userInfo, $categoryInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 编辑获取分类信息
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function getCategoryInfo(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $categoryId = (int)$request->input('category_id', '');

        $result = $this->categoryService->getCategoryInfoHandle($userInfo, $categoryId);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

    /**
     * 编辑保存分类
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function updateCategory(Request $request) {
        $userInfo = $request->attributes->get('user_info');
        $categoryInfo = $request->json()->all();

        $result = $this->categoryService->updateCategoryHandle($userInfo, $categoryInfo);
        if (empty($result['res'])) {
            return $this->respondError(30001, $result['msg'] ?? '');
        }

        return $this->respondSuccess($result['data'] ?? []);
    }

}
