package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 获取房间信息
 * 
 * @author puhui
 *
 */
public class room_info extends XYZB implements API {
	public String Description;//参数集合
	
	public String room_num;
	public String room_name;
	public String start_time;
	public String end_time;
	public String create_time;
	public String province;
	public String city;
	public String area;
	public String office_type;
	public String is_ask;
	public String is_banned;
	public String banned_time;
	public String address;
	public String online_num;
	
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		// 获取parameter对应的内容
		Description = MapUtil.getValue("Description", data);
		if(Description.contains("错误token")){
			Response re = RequestDataUtils.Get_Errtoken(data, Url, Client_token);
			return re;
		}else if(Description.contains("超长token")){
			Response re = RequestDataUtils.Get_Longtoken(data, Url, Client_token);
			return re;
		}else if(Description.contains("无token")){
			Response re = RequestDataUtils.Get_Notoken_NoCookie(data, Url);
			return re;
		}
		Response re = RequestDataUtils.Get_Noparameter(data, Url,Client_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("操作成功".equals(jp.getString("msg"))){
				/**
				 * public String room_num;
					public String room_name;
					public String start_time;
					public String end_time;
					public String create_time;
					public String province;
					public String city;
					public String area;
					public String office_type;
					public String is_ask;
					public String is_banned;
					public String banned_time;
					public String address;
					public String online_num;
				 */
				
				room_num =jp.getString("data.room_num");
				room_name =jp.getString("data.room_name");
				start_time =jp.getString("data.start_time");
				end_time =jp.getString("data.end_time");
				create_time =jp.getString("data.create_time");
				province =jp.getString("data.province");
				area =jp.getString("data.area");
				office_type =jp.getString("data.office_type");
				is_ask =jp.getString("data.is_ask");
				is_banned =jp.getString("data.is_banned");
				banned_time =jp.getString("data.banned_time");
//				address =jp.getString("data.address");
				online_num =jp.getString("data.online_num");
				
				//是否是线上环境
				if (!isProduct) {
					
					try {
						ResultSet xyu_room_users = this.selectFromDB(
								" xyu_room  r ",
								" r.room_num = '" + Current_room + "' ");
						xyu_room_users.last();
						
						String act_room_num = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("room_num")));
						String act_room_name = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("room_name")));
						String act_start_time = xyu_room_users.getString(xyu_room_users.findColumn("start_time"));
						act_start_time=act_start_time.substring(0, act_start_time.length()-2);
						
						String act_end_time = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("end_time")));
						act_end_time=act_end_time.substring(0, act_end_time.length()-2);
						
						String act_create_time = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("create_time")));
						act_create_time=act_create_time.substring(0, act_create_time.length()-2);
						
						String act_province = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("province")));
						String act_area = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("area")));
						String act_office_type = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("office_type")));
						String act_is_ask = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("is_ask")));
						String act_is_banned = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("is_banned")));
						String act_banned_time = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("banned_time")));
//						String act_address = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("address")));
						
						
						ResultSet xyu_room_users_online = this.selectFromDB(
								" xyu_room_users  r ",
								" r.room_num = '" + Current_room + "' and  online = 1 and enabled = 0");
						xyu_room_users_online.last();
						
						String act_online = String.valueOf(xyu_room_users_online.getRow());
						
						System.out.println("接口返回在线人数："+online_num);
						System.out.println("数据库在线人数："+act_online);
						
						
						if ((!room_num.equals(act_room_num)) ||
								(!room_name.equals(act_room_name)) ||
								(!start_time.equals(act_start_time)) ||
								(!end_time.equals(act_end_time)) ||
								(!create_time.equals(act_create_time)) ||
								(!province.equals(act_province)) ||
								(!area.equals(act_area)) ||
								(!office_type.equals(act_office_type)) ||
								(!is_ask.equals(act_is_ask)) ||
								(!is_banned.equals(act_is_banned)) ||
								(!banned_time.equals(act_banned_time))||
//								(!address.equals(act_address)) ||
								(!online_num.equals(act_online))  ){
							
							result = result && false;
							failReason = failReason + "xyu_room info in DB is wrong;";
						} else {
							Log.logInfo("xyu_room info in DB is correct;");
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify xyu_room info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
