package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.util.HashMap;
import java.util.Map;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.BasicsGM;
import com.offcn.process.XYZB;



/**
 * 流程-编辑房间
 * 
 * @author puhui
 *
 */
public class edit extends XYZB implements API {
	public String parameter;//参数集合
	public String room_name;//房间名称
	public static String start_time;//开始时间
	public static String end_time;//结束时间
	public String Description;//用例名称
	
	public String office_type;//公职类别
	public String province;//地区
	public String city;//城市
	public String area;//区县

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		room_name = MapUtil.getParameter(parameter, "room_name").trim();
		start_time = MapUtil.getParameter(parameter, "start_time").trim();
		end_time = MapUtil.getParameter(parameter, "end_time").trim();
		
		office_type = MapUtil.getParameter(parameter, "office_type").trim();
		province = MapUtil.getParameter(parameter, "province").trim();
		city = MapUtil.getParameter(parameter, "city").trim();
		area = MapUtil.getParameter(parameter, "area").trim();
		
		if ((!room_name.equals("")) && room_name.equals("code")) {
			parameter = parameter.replace("\"room_name\":code", "\"room_name\":\""+ room_names.get("Not_edited") + "\"");
		}
		
		// 获取Description对应的内容
		Description = MapUtil.getValue("Description", data);
		if(Description.contains("未开始")){
			if ((!start_time.equals("")) && start_time.equals("code")) {
				parameter = parameter.replace("\"start_time\":code", "\"start_time\":\""+ MyDateUtil.getTime(24, 0, 0) + "\"");
				start_time=MyDateUtil.getTime(24, 0, 0);
			}
			if ((!end_time.equals("")) && end_time.equals("code")) {
				parameter = parameter.replace("\"end_time\":code", "\"end_time\":\""+ MyDateUtil.getTime(24, 1, 1) + "\"");
				end_time=MyDateUtil.getTime(24, 1, 1);
			}
			Not_started_xyzb.put("teacher_password", Not_edited_xyzb.get("teacher_password"));
			Not_started_xyzb.put("student_password", Not_edited_xyzb.get("student_password"));
			Not_started_xyzb.put("assistant_password", Not_edited_xyzb.get("assistant_password"));
			Not_started_xyzb.put("host_password", Not_edited_xyzb.get("host_password"));
			Not_started_xyzb.put("id", Not_edited_xyzb.get("id"));
			room_nums.put("Not_started",  room_nums.get("Not_edited"));
			room_names.put("Not_started", room_names.get("Not_edited"));
			
//			System.out.println( Not_edited_xyzb.get("id"));
			
			ReadProperties.updateProperty("Not_started_xyzbid",  Not_edited_xyzb.get("id").toString());
			ReadProperties.updateProperty("Not_started_xyzbroom_nums", room_nums.get("Not_started").toString());
			ReadProperties.updateProperty("Not_started_xyzbroom_names", room_names.get("Not_edited").toString());
			ReadProperties.updateProperty("Not_started_xyzbteacher_password", Not_edited_xyzb.get("teacher_password").toString());
			ReadProperties.updateProperty("Not_started_xyzbstudent_password",Not_edited_xyzb.get("student_password").toString());
			ReadProperties.updateProperty("Not_started_xyzbassistant_password", Not_edited_xyzb.get("assistant_password").toString());
			ReadProperties.updateProperty("Not_started_xyzbhost_password", Not_edited_xyzb.get("host_password").toString());
			
//			System.out.println(MapUtil.showMap(Not_edited_xyzb));
//			System.out.println(MapUtil.showMap(Not_started_xyzb));
//			System.out.println(MapUtil.showMap(room_nums));
//			System.out.println(MapUtil.showMap(room_names));
			
		}else if(Description.contains("直播中")){
			if ((!start_time.equals("")) && start_time.equals("code")) {
				parameter = parameter.replace("\"start_time\":code", "\"start_time\":\""+ MyDateUtil.getTime(0, 0, 5) + "\"");
				start_time=MyDateUtil.getTime(0, 0, 5);
			}
			if ((!end_time.equals("")) && end_time.equals("code")) {
				parameter = parameter.replace("\"end_time\":code", "\"end_time\":\""+ MyDateUtil.getTime(24, 0, 5) + "\"");
				end_time=MyDateUtil.getTime(24, 0, 5);
			}
			Running_xyzb.put("teacher_password", Not_edited_xyzb.get("teacher_password"));
			Running_xyzb.put("student_password", Not_edited_xyzb.get("student_password"));
			Running_xyzb.put("assistant_password", Not_edited_xyzb.get("assistant_password"));
			Running_xyzb.put("host_password", Not_edited_xyzb.get("host_password"));
			Running_xyzb.put("id", Not_edited_xyzb.get("id"));
			room_nums.put("Running_xyzb",  room_nums.get("Not_edited"));
			room_names.put("Running_xyzb", room_names.get("Not_edited"));
			
			ReadProperties.updateProperty("Running_xyzbid", Not_edited_xyzb.get("id").toString());
			ReadProperties.updateProperty("Running_xyzbroom_nums", room_nums.get("Not_edited").toString());
			ReadProperties.updateProperty("Running_xyzbroom_names", room_names.get("Not_edited").toString());
			ReadProperties.updateProperty("Running_xyzbteacher_password", Not_edited_xyzb.get("teacher_password").toString());
			ReadProperties.updateProperty("Running_xyzbstudent_password",Not_edited_xyzb.get("student_password").toString());
			ReadProperties.updateProperty("Running_xyzbassistant_password", Not_edited_xyzb.get("assistant_password").toString());
			ReadProperties.updateProperty("Running_xyzbhost_password",  Not_edited_xyzb.get("host_password").toString());
			
			
//			System.out.println(MapUtil.showMap(Not_edited_xyzb));
//			System.out.println(MapUtil.showMap(Running_xyzb));
//			System.out.println(MapUtil.showMap(room_nums));
//			System.out.println(MapUtil.showMap(room_names));
			
			
			
		}else if(Description.contains("已结束")){
			if ((!start_time.equals("")) && start_time.equals("code")) {
				parameter = parameter.replace("\"start_time\":code", "\"start_time\":\""+ MyDateUtil.getTime(0, 0, 5) + "\"");
				start_time=MyDateUtil.getTime(0, 0, 5);
			}
			if ((!end_time.equals("")) && end_time.equals("code")) {
				parameter = parameter.replace("\"end_time\":code", "\"end_time\":\""+ MyDateUtil.getTime(0, 0, 6) + "\"");
				end_time=MyDateUtil.getTime(0, 0, 6);
			}
			Finished_xyzb.put("teacher_password", Not_edited_xyzb.get("teacher_password"));
			Finished_xyzb.put("student_password", Not_edited_xyzb.get("student_password"));
			Finished_xyzb.put("assistant_password", Not_edited_xyzb.get("assistant_password"));
			Finished_xyzb.put("host_password", Not_edited_xyzb.get("host_password"));
			Finished_xyzb.put("id", Not_edited_xyzb.get("id"));
			room_nums.put("Finished_xyzb",  room_nums.get("Not_edited"));
			room_names.put("Finished_xyzb", room_names.get("Not_edited"));
			
			ReadProperties.updateProperty("Finished_xyzbid",  Not_edited_xyzb.get("id").toString());
			ReadProperties.updateProperty("Finished_xyzbroom_nums", room_nums.get("Not_edited").toString());
			ReadProperties.updateProperty("Finished_xyzbroom_names", room_names.get("Not_edited").toString());
			ReadProperties.updateProperty("Finished_xyzbteacher_password", Not_edited_xyzb.get("teacher_password").toString());
			ReadProperties.updateProperty("Finished_xyzbstudent_password",Not_edited_xyzb.get("student_password").toString());
			ReadProperties.updateProperty("Finished_xyzbassistant_password", Not_edited_xyzb.get("assistant_password").toString());
			ReadProperties.updateProperty("Finished_xyzbhost_password",  Not_edited_xyzb.get("host_password").toString());
			
			
//			System.out.println(MapUtil.showMap(Not_edited_xyzb));
//			System.out.println(MapUtil.showMap(Finished_xyzb));
//			System.out.println(MapUtil.showMap(room_nums));
//			System.out.println(MapUtil.showMap(room_names));
			
			
			
		}else if(Description.contains("已失效")){
			if ((!start_time.equals("")) && start_time.equals("code")) {
				parameter = parameter.replace("\"start_time\":code", "\"start_time\":\""+ MyDateUtil.getTime(0, 0, 5) + "\"");
				start_time=MyDateUtil.getTime(0, 0, 5);
			}
			if ((!end_time.equals("")) && end_time.equals("code")) {
				parameter = parameter.replace("\"end_time\":code", "\"end_time\":\""+ MyDateUtil.getTime(0, 1, 6) + "\"");
				end_time=MyDateUtil.getTime(0, 1, 6);
			}
			Invalid_xyzb.put("teacher_password", Not_edited_xyzb.get("teacher_password"));
			Invalid_xyzb.put("student_password", Not_edited_xyzb.get("student_password"));
			Invalid_xyzb.put("assistant_password", Not_edited_xyzb.get("assistant_password"));
			Invalid_xyzb.put("host_password", Not_edited_xyzb.get("host_password"));
			Invalid_xyzb.put("id", Not_edited_xyzb.get("id"));
			room_nums.put("Invalid_xyzb",  room_nums.get("Not_edited"));
			room_names.put("Invalid_xyzb", room_names.get("Not_edited"));
			
			ReadProperties.updateProperty("Invalid_xyzbid", Not_edited_xyzb.get("id").toString());
			ReadProperties.updateProperty("Invalid_xyzbroom_nums", room_nums.get("Not_edited").toString());
			ReadProperties.updateProperty("Invalid_xyzbroom_names", room_names.get("Not_edited").toString());
			ReadProperties.updateProperty("Invalid_xyzbteacher_password", Not_edited_xyzb.get("teacher_password").toString());
			ReadProperties.updateProperty("Invalid_xyzbstudent_password",Not_edited_xyzb.get("student_password").toString());
			ReadProperties.updateProperty("Invalid_xyzbassistant_password", Not_edited_xyzb.get("assistant_password").toString());
			ReadProperties.updateProperty("Invalid_xyzbhost_password",  Not_edited_xyzb.get("host_password").toString());
			
			
//			System.out.println(MapUtil.showMap(Not_edited_xyzb));
//			System.out.println(MapUtil.showMap(Invalid_xyzb));
//			System.out.println(MapUtil.showMap(room_nums));
//			System.out.println(MapUtil.showMap(room_names));
			
		}
		// 替换原来的parameter
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Map<String, Object>  jsonAsMap = new HashMap<>();
		parameter = MapUtil.getValue("parameter", data);
		
		room_name = MapUtil.getParameter(parameter, "room_name").trim();
		office_type = MapUtil.getParameter(parameter, "office_type").trim();
		province = MapUtil.getParameter(parameter, "province").trim();
		city = MapUtil.getParameter(parameter, "city").trim();
		area = MapUtil.getParameter(parameter, "area").trim();
		
		jsonAsMap.put("start_time", start_time);
		jsonAsMap.put("end_time", end_time);
		jsonAsMap.put("room_name", room_names.get("Not_edited"));
		jsonAsMap.put("office_type", office_type);
		jsonAsMap.put("province", province);
		jsonAsMap.put("city", city);
		jsonAsMap.put("area", area);
//		System.out.println(room_nums.get("Not_edited"));
		Response re = RequestDataUtils.Put_Token(data,Salesman_token, "/api/room/"+room_nums.get("Not_edited"),jsonAsMap);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data").length()>4){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			
		}
		if (result){
				// 获取Description对应的内容
				Description = MapUtil.getValue("Description", data);
			if(Description.contains("未开始")){
				BasicsGM.updateOrderStatus("xyu.xyu_room","status=1", "room_num="+room_nums.get("Not_started"));
			}else if(Description.contains("直播中")){
				BasicsGM.updateOrderStatus("xyu.xyu_room","status=2", "room_num="+room_nums.get("Running_xyzb"));
			}else if(Description.contains("已结束")){
				BasicsGM.updateOrderStatus("xyu.xyu_room","status=3", "room_num="+room_nums.get("Finished_xyzb"));
			}else if(Description.contains("已失效")){
				BasicsGM.updateOrderStatus("xyu.xyu_room","status=4", "room_num="+room_nums.get("Invalid_xyzb"));
				BasicsGM.updateOrderStatus("xyu.xyu_room","start_time='2017-02-11 11:11:11' ", "room_num="+room_nums.get("Invalid_xyzb"));
				BasicsGM.updateOrderStatus("xyu.xyu_room","end_time='2017-02-11 12:12:12' ", "room_num="+room_nums.get("Invalid_xyzb"));
			}
			return "Pass";
		}else{
			return "Fail:" + failReason;
		}
	}

	
}
