package com.offcn.TestUnti;

import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsResourceDetails;
import org.springframework.security.oauth2.common.OAuth2AccessToken;

import com.offcn.process.BasicsGM;
import com.offcn.system.system;
import com.offcn.test.APITest;

import java.util.Arrays;



public class OAuthTokenUnti {

	public APITest RAPI;
//    private static OAuth2AccessToken token;
    public static OAuth2AccessToken token;
    public static void main(String[] args) {
    	String strToken=OAuthTokenUnti.getOathToken("gmysx").getValue();
    	System.out.println("strToken="+strToken);
	}

    public static OAuth2AccessToken getOathToken(String system){
        if(token == null){
            OAuth2RestTemplate restTemplate = new OAuth2RestTemplate(getResource(system),new DefaultOAuth2ClientContext(new DefaultAccessTokenRequest()));
            MappingJackson2HttpMessageConverter converter = new MappingJackson2HttpMessageConverter();
            restTemplate.setMessageConverters(Arrays.<HttpMessageConverter<?>> asList(converter));
            token = restTemplate.getAccessToken();
        }
        return  token;
    }

    private static ClientCredentialsResourceDetails getResource(String system){
        ClientCredentialsResourceDetails resource = new ClientCredentialsResourceDetails();
        system tem=(system)(BasicsGM.map.get(system));
        resource.setAccessTokenUri(tem.getAccess_token_uri());
        resource.setClientId(tem.getClient_id());
        resource.setClientSecret(tem.getClient_secret());
        resource.setGrantType(tem.getGrant_type());
        return resource;
    }
    

}
