package com.offcn.TestUnti;

import io.restassured.RestAssured;
import io.restassured.config.RestAssuredConfig;
import io.restassured.config.SSLConfig;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static io.restassured.http.ContentType.JSON;

/**
 * Created by puhui on 16/9/14.
 */
public class MockServerTestUtil {
    static RestAssured ra;

    public static RestAssured getLocalRAEnv(){
        if (ra == null){
            ra = new RestAssured();
            ra.config = RestAssuredConfig.newConfig().sslConfig(SSLConfig.sslConfig().allowAllHostnames());
            ra.baseURI = "http://127.0.0.1";
            ra.port = 30800;

        }
        return ra;
    }

    public static void sendSingleMessageResponse(String mobile,  String messageContent){
        Response re = getLocalRAEnv().given().
                    param("token", "faketoken").
                    param("senderId", 1).
                    param("senderName", "iqianjin").
                    param("mobile", mobile).
                    param("messageContent", messageContent).
                    param("bsCode", "sbcode").
                when().get("/api/v1/message/getSend").thenReturn();
        re.getBody().print();
        re.then().statusCode( 200 );
    }

    //batchNo批次号非必要参数,
    // messageContent messageContents 单条内容和多条容不能共存,优先单一内容发送，多条内容发送是与发送号码一一对应的。
    public static JsonPath sendmutiMessageResponse(List<String> mobiles,  List<String> messageContents){
        Map<String, Object> jsonAsMap = new HashMap();
        jsonAsMap.put("senderName","testmuti");
        jsonAsMap.put("messageContents",messageContents);
        jsonAsMap.put("mobiles",mobiles);
        jsonAsMap.put("bscode","fakebscode");

        Response re = getLocalRAEnv().given().contentType(JSON).body(jsonAsMap).
                when(). post("/api/v1/message/send").thenReturn();
        re.getBody().print();
        re.then().statusCode( 200 );
        return re.getBody().jsonPath();
    }

    public static JsonPath getSingleMessageResponse(String mobile){
        Response re = getLocalRAEnv().given().
                param("mobile", mobile).
                when(). get("/api/v1/message/query").thenReturn();
        re.getBody().print();
        re.then().statusCode( 200 );
        return re.getBody().jsonPath();
    }
}
