package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.BasicsGM;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 客户端登陆
 * 
 * @author puhui
 *
 */
public class users extends XYZB implements API {

	public String parameter;//参数集合
	public String Description;//用例名称
	public String password;//姓名
	public String nickname;//昵称
	public String uuid;//
	
	public String zgl_clienttype;//学生或者是老师
	public String zgl_systemtype;//系统
	@Override
	public void initialize(HashMap<String, Object> data) {
		if (!isProduct && data.get("CleanDB").toString().contains("Y")) {
			this.cleanRoom_numsFromDB();//清除房间内已登录的用户信息
		}
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		parameter = MapUtil.getValue("parameter", data);
		password = MapUtil.getParameter(parameter, "password").trim();
		nickname = MapUtil.getParameter(parameter, "nickname").trim();
		uuid = MapUtil.getParameter(parameter, "uuid").trim();
		Description = MapUtil.getValue("Description", data);
		
		zgl_clienttype="ZgLiveStudent";//没有口令时候默认学生身份
		if (!password.equals("") && password.length()!=12){//12位是不需要替换的明文口令
			//保存当前用户类型
			Current_password=password;
			if(password.contains("student")){
				zgl_clienttype="ZgLiveStudent";
			}else{
				zgl_clienttype="ZgLiveTeacher";
			}
			//保存当前用户口令和房间号
			Current_user=ReadProperties.GetinformationByKey(password);
			if ((!password.equals("")) && password.contains("Not_edited")) {
				Current_room=ReadProperties.GetinformationByKey("Not_edited_xyzbroom_nums");
				Current_room_id=ReadProperties.GetinformationByKey("Not_edited_xyzbid");
			}
			if ((!password.equals("")) && password.contains("Not_started")) {
				Current_room=ReadProperties.GetinformationByKey("Not_started_xyzbroom_nums");
				Current_room_id=ReadProperties.GetinformationByKey("Not_started_xyzbid");
			}
			if ((!password.equals("")) && password.contains("Running_xyzb")) {
				Current_room=ReadProperties.GetinformationByKey("Running_xyzbroom_nums");
				Current_room_id=ReadProperties.GetinformationByKey("Running_xyzbid");
			}
			if ((!password.equals("")) && password.contains("Finished_xyzb")) {
				Current_room=ReadProperties.GetinformationByKey("Finished_xyzbroom_nums");
				Current_room_id=ReadProperties.GetinformationByKey("Finished_xyzbid");
			}
			if ((!password.equals("")) && password.contains("Invalid_xyzb")) {
				Current_room=ReadProperties.GetinformationByKey("Invalid_xyzbroom_nums");
				Current_room_id=ReadProperties.GetinformationByKey("Invalid_xyzbid");
			}
			
			parameter = parameter.replace("\"password\":"+password, 
					"\"password\":\""+ Current_user + "\"");
			if("Not_started_xyzbstudent_password".equals(password)  && Description.contains("正向")){
				BasicsGM.updateOrderStatus(" xyu.xyu_room "," start_time = '"+MyDateUtil.getTime(0, -10, 0)+"' ", " student_password ='"+ReadProperties.GetinformationByKey(password)+"'");
			}
			if("Not_started_xyzbstudent_password".equals(password)  && Description.contains("反向")){
				BasicsGM.updateOrderStatus(" xyu.xyu_room "," start_time = '"+MyDateUtil.getTime(0, 40, 0)+"' ", " student_password ='"+ReadProperties.GetinformationByKey(password)+"'");
			}
		}
		
		if ((!nickname.equals("")) && nickname.equals("random")) {
			Current_nickname="ys"+(new Random().nextInt(90000000)+ 10000000);
			parameter = parameter.replace("\"nickname\":random", "\"nickname\":\""+ Current_nickname + "\"");
		}
		
		if ((!uuid.equals("")) &&  uuid!=null) {
			Current_uuid=uuid;
		}
		if ((!uuid.equals("")) && uuid.equals("random")) {
			Current_uuid="ys"+(new Random().nextInt(90000000)+ 10000000);
			parameter = parameter.replace("\"uuid\":random", "\"uuid\":\""+ Current_uuid + "\"");
		}
		
		
		// 替换原来的parameter
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
//		Response re = RequestDataUtils.Post_NOToken(data, Url);
		Response re = RequestDataUtils.Post_headers(data, Url,zgl_clienttype);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();
		
//		System.out.println(json);
//
//		System.out.println(data.get("statusCode"));
//		System.out.println(re.getStatusCode());
		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString().equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if (jp.getString("data") != null){
				String token_data=jp.getString("data.access_token");
//				String[] token_arr=token_data.split(",");
//				String[] token_value=token_arr[0].split(":");
//				Client_token=token_value[1];
				Client_token=token_data;
			}
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
