package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MyDateUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 创建房间（不在测试范围）
 * 
 * @author puhui
 *
 */
public class room extends XYZB implements API {
	public String parameter;//参数集合
	public String room_name;//房间名称
	
	public String teacher_password;
	public String student_password;
	public String assistant_password;
	public String host_password;
	public String room_num;
	public String id;

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		room_name = MapUtil.getParameter(parameter, "room_name").trim();
		
		if ((!room_name.equals("")) && room_name.equals("random")) {
//			SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss");
//			String dateStr = dateformat.format(new Date());
			String dateStr =new Random().nextInt(999999)+"";
			room_name="ys"+dateStr;
			parameter = parameter.replace("\"room_name\":random", "\"room_name\":\""+ room_name + "\"");
		}
		// 替换原来的data
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url,Salesman_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null && jp.getString("data").length()>4){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			
			if (jp.getString("data") != null){
				teacher_password=jp.getString("data.teacher_password");
				student_password=jp.getString("data.student_password");
				assistant_password=jp.getString("data.assistant_password");
				host_password=jp.getString("data.host_password");
				room_num=jp.getString("data.room_num");
				id=jp.getString("data.id");
				
				Not_edited_xyzb.put("teacher_password", teacher_password);
				Not_edited_xyzb.put("student_password", student_password);
				Not_edited_xyzb.put("assistant_password", assistant_password);
				Not_edited_xyzb.put("host_password", host_password);
				Not_edited_xyzb.put("id", id);
				
				String room_num=jp.getString("data.room_num");
				room_nums.put("Not_edited", room_num);//存储房间编号
				room_names.put("Not_edited", room_name);//存储房间名称
				
				ReadProperties.updateProperty("Not_edited_xyzbid", id);
				ReadProperties.updateProperty("Not_edited_xyzbroom_nums", room_num);
				ReadProperties.updateProperty("Not_edited_xyzbroom_names", room_name);
				ReadProperties.updateProperty("Not_edited_xyzbteacher_password", Not_edited_xyzb.get("teacher_password").toString());
				ReadProperties.updateProperty("Not_edited_xyzbstudent_password",Not_edited_xyzb.get("student_password").toString());
				ReadProperties.updateProperty("Not_edited_xyzbassistant_password", Not_edited_xyzb.get("assistant_password").toString());
				ReadProperties.updateProperty("Not_edited_xyzbhost_password", Not_edited_xyzb.get("host_password").toString());
			
			
				//是否是线上环境
				if (!isProduct) {
						teacher_password = MapUtil.killQuotes(teacher_password, "\"");//去掉双引号的bankNo
						student_password = MapUtil.killQuotes(student_password, "\"");//去掉双引号的bankNo
						assistant_password = MapUtil.killQuotes(assistant_password, "\"");//去掉双引号的bankNo
						host_password = MapUtil.killQuotes(host_password, "\"");//去掉双引号的bankNo
						room_num = MapUtil.killQuotes(room_num, "\"");//去掉双引号的bankName
						id = MapUtil.killQuotes(id, "\"");//去掉双引号的bankCode
						
						try {
							ResultSet rs_bankcard = this.selectFromDB(
									" xyu_room r ",
									" r.id = '" + id + "' ");
							rs_bankcard.last();
							
							if (rs_bankcard.getRow() < 1) {
								result = result && false;
								failReason = failReason + "xyu_users info is not in DB;";
							} else {
								teacher_password = (teacher_password != null)
										? String.valueOf(teacher_password).trim() : "";
								student_password = (student_password != null)
										? String.valueOf(student_password).trim() : "";
								assistant_password = (assistant_password != null)
										? String.valueOf(assistant_password).trim() : "";
								host_password = (host_password != null)
										? String.valueOf(host_password).trim() : "";
								room_num = (room_num != null)
										? String.valueOf(room_num).trim() : "";
	
								String act_teacher_password = String
										.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("teacher_password")));
								String act_student_password = String
										.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("student_password")));
								String act_assistant_password = String
										.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("assistant_password")));
								String act_host_password = String
										.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("host_password")));
								String act_room_num = String
										.valueOf(rs_bankcard.getString(rs_bankcard.findColumn("room_num")));
	
								
								if ((!teacher_password.equals(act_teacher_password)) 
										|| (!student_password.equals(act_student_password))
										|| (!assistant_password.equals(act_assistant_password))
										|| (!host_password.equals(act_host_password))
										|| (!room_num.equals(act_room_num))) {
									result = result && false;
									failReason = failReason + "xyu_room info in DB is wrong;";
								} else {
									 Log.logInfo("xyu_room info in DB is correct;");
								}
							}
						} catch (Exception e) {
							result = result && false;
							failReason = failReason + "cannot verify xyu_room info in DB;";
							e.printStackTrace();
						}
					}
			}else{
				result = result && false;
			}
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
