package com.offcn.api.xyzb;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.ReadProperties;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.XYZB;

import net.sf.json.JSONObject;



/**
 * 获取用户信息
 * 
 * @author puhui
 *
 */
public class getUser extends XYZB implements API {
	public String parameter;//参数集合
	public String Description;
	public String uuid;
	
	public String id;
	public String room_num;
	public String nickname;
	public String speaking_status;
	public String enabled;
	public String role;
	public String created_at;
	public String updated_at;
	public String online;
	
	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		parameter = MapUtil.getValue("parameter", data);
		uuid = MapUtil.getParameter(parameter, "uuid").trim();
		uuid = MapUtil.killQuotes(uuid, "\"");//去掉双引号的education
		
		if ((!uuid.equals("")) && uuid.equals("code")) {
			
			parameter =  Current_uuid;
			parameter = MapUtil.killQuotes(parameter, "\"");//去掉双引号的parameter
			data.put("parameter", parameter);
			return data;
		}
		
		// 替换原来的parameter
		data.put("parameter", uuid);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		// 获取parameter对应的内容
		Description = MapUtil.getValue("Description", data);
		
		if(Description.contains("错误token")){
			Response re = RequestDataUtils.Get_Errtoken(data, "/api/v1/users", Client_token);
			return re;
		}else if(Description.contains("超长token")){
			Response re = RequestDataUtils.Get_Longtoken(data, "/api/v1/users", Client_token);
			return re;
		}else if(Description.contains("无token")){
			Response re = RequestDataUtils.Get_Notoken(data, "/api/v1/users");
			return re;
		}
		Response re = RequestDataUtils.Get_Noparameter(data, "/api/v1/users",Client_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(jp.getString("msg"));
			
			if ((data.get("code") != null )
					&& ((jp.getString("code") == null) || (!jp.getString(
							"code").equals(data.get("code").toString())))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null)
					&& ((msg == null) || (!msg.equals(data.get("msg").toString())))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
				
			if((data.get("custom") != null) && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			
			if (jp.getString("data") != null) {
				parameter = MapUtil.getValue("parameter", data);
				
				id =jp.getString("data.id");
				room_num =jp.getString("data.room_num");
				nickname =jp.getString("data.nickname");
				role =jp.getString("data.role");
				speaking_status =jp.getString("data.speaking_status");
				enabled =jp.getString("data.enabled");
				online =jp.getString("data.online");
				
				try {
					ResultSet xyu_room_users=null;
					if(id!=null){
						xyu_room_users = this.selectFromDB(
								" xyu_room_users r ",
								" r.uuid = '" + parameter + "' ");
						xyu_room_users.last();
						String act_id = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("id")));
						String act_room_num = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("room_num")));
						String act_nickname = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("nickname")));
						String act_role = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("role")));
						String act_speaking_status = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("speaking_status")));
						String act_enabled = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("enabled")));
						String act_online = String.valueOf(xyu_room_users.getString(xyu_room_users.findColumn("online")));
						
						
						if (!act_id.equals(id)) {
							result = result && false;
							failReason = failReason + "id  is not  find;";
						} 
						if (!act_room_num.equals(room_num)) {
							result = result && false;
							failReason = failReason + "re_room_num  is not  find;";
						} 
						if(!act_nickname.equals(nickname)){
							result = result && false;
							failReason = failReason + "Current_nickname  is not  find;";
						}
						if(!act_role.contains(role)){
							result = result && false;
							failReason = failReason + "Current_password  is not  find;";
						}
						if(!act_speaking_status.equals(speaking_status)){
							result = result && false;
							failReason = failReason + "re_speaking_status  is not  find;";
						}
						if(!act_enabled.equals(enabled)){
							result = result && false;
							failReason = failReason + "re_enabled  is not  find;";
						}
						if(!act_online.equals(online)){
							result = result && false;
							failReason = failReason + "re_online  is not  find;";
						}
					}
					
					
				} catch (Exception e) {
					result = result && false;
					failReason = failReason + "cannot verify xyu_room info in DB;";
					e.printStackTrace();
				}
			}
		}
		
		if (result){
			Current_user_id=id;
			return "Pass";
		}else{
			return "Fail:" + failReason;
		}
	}

}
