package com.offcn.api.tk;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 修改默认地区
 * 
 * @author puhui
 *
 */
public class setDefaultArea extends TK implements API {
	public String parameter;//参数集合
	
	public String user_id;//用户id
	public String area_id;//用户id

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		user_id = MapUtil.getParameter(parameter, "user_id").trim();
		area_id = MapUtil.getParameter(parameter, "area_id").trim();

		
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		
		if ((!area_id.equals("")) && area_id.equals("code")) {
			area_id=ListUtil.getListValue(t_exam_area,0);
			parameter = parameter.replace("\"area_id\":code", "\"area_id\":\""+ area_id + "\"");
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url,tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("接口响应成功！".equals(msg)){
				
				//是否验证数据库
				if (!isProduct) {
					user_id = MapUtil.killQuotes(user_id, "\"");
					area_id = MapUtil.killQuotes(area_id, "\"");
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" t_exam_area u ",
								" u.if_default = '" + 1 + "'");
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							
							String act_user_id=rs_bankcard.getString("user_id").equals("null ")?"null":rs_bankcard.getString("user_id");
							String act_id=rs_bankcard.getString("id").equals("null ")?"null":rs_bankcard.getString("id");
							
							if(!(user_id.equals(act_user_id))){
									result = result && false;
									failReason = failReason + "act_user_id  is not in DB;";
							}
							if(!(area_id.equals(act_id))){
								result = result && false;
								failReason = failReason + "area_id  is not in DB;";
							}
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "not find t_exam_area  in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
