package com.offcn.api.tk;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.MySqlUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 获取验证码
 * 
 * @author puhui
 *
 */
public class getCode extends TK implements API {
	public String parameter;//参数集合
	
	public String phone;//用户手机号


	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		phone = MapUtil.getParameter(parameter, "phone").trim();

		if ((!phone.equals("")) && phone.equals("random")) {
			phone="1391"+(new Random().nextInt(9000000)+ 1000000);
			parameter = parameter.replace("\"phone\":random", "\"phone\":\""+ phone + "\"");
		}
		
		if ((!phone.equals("")) && phone.equals("code")) {
			phone=phoneNeb;
			parameter = parameter.replace("\"phone\":code", "\"phone\":\""+ phone + "\"");
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url,tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("验证码发送正常请求".equals(msg)){
				
				//是否验证数据库
				if (!isProduct) {
					parameter = MapUtil.getValue("parameter", data);
					phone = MapUtil.getParameter(parameter, "phone").trim();
					phone = MapUtil.killQuotes(phone, "\"");
					phoneNeb=phone;
					
					String data_code=jp.getString("data.code");
					phone_code=data_code;
					
					try {
						ResultSet rs_bankcard = this.selectFromDB(
								" t_code u ",
								" u.phone = '" + phone + "'");
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							
							String act_phone=rs_bankcard.getString("phone").equals("null ")?"null":rs_bankcard.getString("phone");
							String act_code=rs_bankcard.getString("code").equals("null ")?"null":rs_bankcard.getString("code");
							
							if(!(act_phone.equals(phone))){
									result = result && false;
									failReason = failReason + "phone  is not in DB;";
							}
							if(!(data_code.equals(act_code))){
								result = result && false;
								failReason = failReason + "code  is not in DB;";
							}
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "not find t_code  in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
