package com.offcn.api.tk;

import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;

import org.json.simple.JSONArray;

import com.offcn.TestUnti.Log;
import com.offcn.TestUnti.MapUtil;
import com.offcn.TestUnti.RequestDataUtils;
import com.offcn.TestUnti.StringUtils;
import com.offcn.interfaces.API;
import com.offcn.process.TK;
import com.offcn.TestUnti.ListUtil;

import net.sf.json.JSONObject;



/**
 * 用户地区操作
 * 
 * @author puhui
 *
 */
public class area extends TK implements API {
	public String parameter;//参数集合
	
	public String type;//操作类型
	public String user_id;//用户id
	public String province_id;//省id
	public String id;//t_exam_area表的主键，用于删除记录

	@Override
	public void initialize(HashMap<String, Object> data) {
	}

	@Override
	public HashMap<String, Object> handleInput(HashMap<String, Object> data) {
		// 获取parameter对应的内容
		parameter = MapUtil.getValue("parameter", data);
		user_id = MapUtil.getParameter(parameter, "user_id").trim();
		type = MapUtil.getParameter(parameter, "type").trim();
		id = MapUtil.getParameter(parameter, "id").trim();

		
		if ((!user_id.equals("")) && user_id.equals("code")) {
			user_id=ListUtil.getListValue(user_idList,0);
			parameter = parameter.replace("\"user_id\":code", "\"user_id\":\""+ user_id + "\"");
		}
		
		
		if ((!id.equals("")) && id.equals("code")) {
			id=ListUtil.getListValue(t_exam_area,0);
			parameter = parameter.replace("\"id\":code", "\"id\":\""+ id + "\"");
		}
		
		data.put("parameter", parameter);
		return data;
	}

	@Override
	public Response SendRequest(HashMap<String, Object> data, String Url,
			String Request) {
		Response re = RequestDataUtils.Post_token(data, Url,tk_token);
		return re;
	}

	@Override
	public String handleOutput(Response re, HashMap<String, Object> data) {
		JsonPath jp = re.body().jsonPath();
		boolean result = true;
		String failReason = "";

		String json = re.asString();

		if ((data.get("statusCode") != null)
				&& (!data.get("statusCode").toString()
						.equals(String.valueOf(re.getStatusCode())))) {
			result = result && false;
			failReason = failReason + "statusCode is expected "
					+ data.get("statusCode").toString() + " but actually "
					+ String.valueOf(re.getStatusCode()) + ". ";
		}

		if (json.length() != 0) {
			
			String msg=StringUtils.decodeUnicode(getMsg(re));
			String code=getCode(re);
			
			if ((data.get("code") != null ) && (code != null) && (!code.equals(data.get("code").toString()))) {
				result = result && false;
				failReason = failReason + "code is expected "
						+ data.get("code").toString() + " but actually "
						+ jp.getString("code") + ".";
			}

			if ((data.get("msg") != null) && (msg != null) && (!msg.equals(data.get("msg").toString()))) {
				result = result && false;
				failReason = failReason + "msg is expected "
						+ data.get("msg").toString() + " but actually "
						+ jp.getString("msg") + ".";
			}
			
			if(data.get("custom") != null && jp.getString("data")!=null){
				String custom=data.get("custom").toString();
				String[] ArrayString=StringUtils.getArrayString(custom,",");
				if(!StringUtils.VerificationString(jp.getString("data"),ArrayString)){
					result = result && false;
					failReason = failReason + "custom is expected "
							+ data.get("custom").toString() + " but actually "
							+ jp.getString("data") + ".";
				}
			}
			
			if("接口响应成功！".equals(msg) && type.contains("add")){
				

				String item_id=jp.getString("data.item_id");
				item_id = MapUtil.killQuotes(item_id, "\"");
				
				String name=jp.getString("data.name");
				name = MapUtil.killQuotes(name, "\"");
				
				//是否验证数据库
				if (!isProduct) {
					
					province_id = MapUtil.getParameter(parameter, "province_id").trim();
					province_id = MapUtil.killQuotes(province_id, "\"");
					
					
					try {
						
						String sql="select t.item_id , e.name , e.province_id , ea.id ,ea.user_id from"
								+ " t_exam_item t, t_exam_area ea, "
								+ "( select  *  from t_exam te where province_id='"+province_id+"' "
								+ "and  is_delete='0' ) e where "
								+ "t.status='2' and t.exam_id=e.id and ea.user_id='"+user_id+"' "
								+ "and ea.if_delete='0' and ea.province_id='"+province_id+"'";
						
						ResultSet rs_bankcard = this.sqlFromDB(sql);
						rs_bankcard.last();
						
						if(rs_bankcard.getRow()>=1){
							
							
							String act_item_id=rs_bankcard.getString("item_id").equals("null ")?"null":rs_bankcard.getString("item_id");
							String act_name=rs_bankcard.getString("name").equals("null ")?"null":rs_bankcard.getString("name");
//							String act_province_id=rs_bankcard.getString("province_id").equals("null ")?"null":rs_bankcard.getString("platform");
//							String act_user_id=rs_bankcard.getString("user_id").equals("null ")?"null":rs_bankcard.getString("device_id");
							String act_id=rs_bankcard.getString("id").equals("null ")?"null":rs_bankcard.getString("id");
							
							t_exam_area.add(act_id);//保存地区，以后需要删除的必须参数
							
							if(!(item_id.equals(act_item_id))){
									result = result && false;
									failReason = failReason + "t_exam_area info phone is not in DB;";
							}
							
							if(!(name.equals(act_name))){
								result = result && false;
								failReason = failReason + "t_exam_area info system is not in DB;";
							}
							
						}
						
					} catch (Exception e) {
						result = result && false;
						failReason = failReason + "cannot verify t_exam_area info in DB;";
						e.printStackTrace();
					}
				}
			}
			
			
		}
		if (result)
			return "Pass";
		else
			return "Fail:" + failReason;
	}

}
