package aoutTestCode;

import java.io.File;
import java.util.List;
import java.util.Map;

import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ParseXml {
	@SuppressWarnings("unused")
	private String filePath;
	private Document document;
	private Element root;
	
	public ParseXml(String filePath) {
		super();
		this.filePath = filePath;
		this.load(filePath);
	}
	public  void load(String filePath) {
		File file=new File(filePath);
		if(file.exists()){
			SAXReader saxReader=new SAXReader();
			try {
				document=saxReader.read(file);
				root = document.getRootElement();
			} catch (DocumentException e) {
				System.out.println("文件加载异常"+filePath);
			}
		}else{
			System.out.println("文件没找到");
		}	
	}
	public Element getElementObject(String elementPath){
		return (Element)document.selectSingleNode(elementPath);
	}
	public String getElementText(String elementPath){
		Element element=this.getElementObject(elementPath);
		if(element!=null){
			return element.getTextTrim();
		}else{
			return null;
		}
	}
	
	public List<Map<String,String>> getElementsName_text(String parameters){
		Element P=root.element(parameters);
		List<Element> Elements = P.elements("parameter");
		for (Element element : Elements) {
			System.out.print(element.attributeValue("name")+"	");
			System.out.println(element.getTextTrim());
		}
		return null;
	}
	
	
	public static void main(String[] args) {
		ParseXml parseXml=new ParseXml("config/config.xml");
		String element=parseXml.getElementText("/config/browser");
		System.out.println(element);
	}
}
