package aoutTestCode;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.offcn.TestUnti.Log;

import sun.util.logging.resources.logging;


import freemarker.template.Configuration;
import freemarker.template.Template;

public class MakeCode {
	public static void main(String[] args){
		MakeCode mc=new MakeCode();
		try {
//			mc.aoutMakeCode("xml_makecode/MakeCode.xml");
			mc.aoutMakeCode("xml_makecode/rgxs-MakeCode.xml");
		} catch (Exception e) {
			Log.logError("aoutMakeCode_error");
			e.printStackTrace();
		}
		Log.logInfo("aoutMakeCode_ok");
		
	}
	public void aoutMakeCode(String path) throws Exception {
				Configuration cfg = new Configuration();
				cfg.setDirectoryForTemplateLoading(new File("templates")); 
				Map<String,Object> root = new HashMap<String,Object>();
				xmlToftl xml=new xmlToftl(path);
				root.put("package_name", xml.getName("package_name"));
				root.put("implements_name",xml.getName("implements_name"));
				root.put("class_name", xml.getName("class_name"));
				root.put("father_class_name", xml.getName("father_class_name"));
				root.put("parameters", xml.getNameAndKey("parameters","parameter"));
				
				root.put("initialize_Disable", xml.getBoolean("initialize_Disable"));
				root.put("initializes", xml.getNameAndKey("initializes","initialize"));
				
				
				root.put("handleInput_Disable", xml.getBoolean("handleInput_Disable"));
				root.put("handleInput_replaces", xml.getNameAndTypeAndKey("handleInput_replaces","handleInput_replace"));
				root.put("handleInputs_Verifications", xml.getNameAndTypeAndKey("handleInputs_Verifications","handleInputs_Verification"));
				
				root.put("SendRequest_Disable", xml.getBoolean("SendRequest_Disable"));
				root.put("SendRequest", xml.getName("SendRequest"));
				
				root.put("handleOutput_Disable", xml.getBoolean("handleOutput_Disable"));
				root.put("handleOutput_saves", xml.gethandleOutput_save("handleOutput_saves","handleOutput_save","handleOutput"));
				root.put("handleOutput_Table", xml.getName("handleOutput_Table"));
				root.put("handleOutput_TableKey", xml.getKey("handleOutput_Table"));
				
				Template t1 = cfg.getTemplate("code.ftl");
				
				File directory = new File(".");
				String package_name=xml.getName("package_name").replace(".", "\\");
				String FilePath = directory.getCanonicalPath() +File.separator+"src"+File.separator+package_name+File.separator;
				File Files = new File(FilePath);
				File FilesName = new File(FilePath,xml.getName("class_name")+".java");
				Log.logInfo("makeFolder:"+(Files.mkdirs()));
				Log.logInfo("makeFile:"+(FilesName.createNewFile()));
				
				//显示生成的数据
				Writer out = new FileWriter(FilesName);
				t1.process(root, out);
				out.flush();
				out.close();
	}
}
