/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.postgresql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InetType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger(InetType.class);

    public InetType() {
        super("inet", 1111, String.class, false);
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        return resultSet.getString(column);
    }

    public void setSqlValue(Object uuid, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        statement.setObject(column, this.getInet(uuid, statement.getConnection()));
    }

    public Object typeCast(Object arg0) throws TypeCastException {
        return arg0.toString();
    }

    private Object getInet(Object value, Connection connection) throws TypeCastException {
        logger.debug("getInet(value={}, connection={}) - start", value, (Object)connection);
        Object tempInet = null;
        try {
            Class aPGObjectClass = super.loadClass("org.postgresql.util.PGobject", connection);
            Constructor ct = aPGObjectClass.getConstructor(null);
            tempInet = ct.newInstance(null);
            Method setTypeMethod = aPGObjectClass.getMethod("setType", String.class);
            setTypeMethod.invoke(tempInet, "inet");
            Method setValueMethod = aPGObjectClass.getMethod("setValue", String.class);
            setValueMethod.invoke(tempInet, value.toString());
        }
        catch (ClassNotFoundException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (NoSuchMethodException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (IllegalAccessException e) {
            throw new TypeCastException(value, this, e);
        }
        catch (InstantiationException e) {
            throw new TypeCastException(value, this, e);
        }
        return tempInet;
    }
}

