/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.sql.ORAData;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.dbunit.ext.oracle.OracleSdoElemInfoArray;
import org.dbunit.ext.oracle.OracleSdoGeometry;
import org.dbunit.ext.oracle.OracleSdoOrdinateArray;
import org.dbunit.ext.oracle.OracleSdoPointType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleSdoGeometryDataType
extends AbstractDataType {
    private static final Logger logger = LoggerFactory.getLogger(OracleSdoGeometryDataType.class);
    private static final String NULL = "NULL";
    private static final String SDO_GEOMETRY = "SDO_GEOMETRY";
    private static final Pattern sdoGeometryPattern = Pattern.compile("^(?:MDSYS\\.)?SDO_GEOMETRY\\s*\\(\\s*([^,\\s]+)\\s*,\\s*([^,\\s]+)\\s*,\\s*");
    private static final Pattern sdoPointTypePattern = Pattern.compile("^(?:(?:(?:MDSYS\\.)?SDO_POINT_TYPE\\s*\\(\\s*([^,\\s]+)\\s*,\\s*([^,\\s]+)\\s*,\\s*([^,\\s\\)]+)\\s*\\))|(NULL))\\s*,\\s*");
    private static final Pattern sdoElemInfoArrayPattern = Pattern.compile("^(?:(?:(?:(?:MDSYS\\.)?SDO_ELEM_INFO_ARRAY\\s*\\(([^\\)]*)\\))|(NULL)))\\s*,\\s*");
    private static final Pattern sdoOrdinateArrayPattern = Pattern.compile("^(?:(?:(?:(?:MDSYS\\.)?SDO_ORDINATE_ARRAY\\s*\\(([^\\)]*)\\))|(NULL)))\\s*\\)\\s*");

    OracleSdoGeometryDataType() {
        super(SDO_GEOMETRY, 2002, OracleSdoGeometry.class, false);
    }

    public Object typeCast(Object value) throws TypeCastException {
        logger.debug("typeCast(value={}) - start", value);
        if (value == null || value == ITable.NO_VALUE) {
            return null;
        }
        if (value instanceof OracleSdoGeometry) {
            return (OracleSdoGeometry)value;
        }
        if (value instanceof String) {
            try {
                OracleSdoOrdinateArray sdoOrdinateArray;
                OracleSdoElemInfoArray sdoElemInfoArray;
                String upperVal = ((String)value).toUpperCase().trim();
                if (NULL.equals(upperVal)) {
                    return null;
                }
                Matcher sdoGeometryMatcher = sdoGeometryPattern.matcher(upperVal);
                if (!sdoGeometryMatcher.find()) {
                    throw new TypeCastException(value, this);
                }
                BigDecimal gtype = NULL.equals(sdoGeometryMatcher.group(1)) ? null : new BigDecimal(sdoGeometryMatcher.group(1));
                BigDecimal srid = NULL.equals(sdoGeometryMatcher.group(2)) ? null : new BigDecimal(sdoGeometryMatcher.group(2));
                Matcher sdoPointTypeMatcher = sdoPointTypePattern.matcher(upperVal = upperVal.substring(sdoGeometryMatcher.end()));
                if (!sdoPointTypeMatcher.find()) {
                    throw new TypeCastException(value, this);
                }
                OracleSdoPointType sdoPoint = NULL.equals(sdoPointTypeMatcher.group(4)) ? null : new OracleSdoPointType(NULL.equals(sdoPointTypeMatcher.group(1)) ? null : new BigDecimal(sdoPointTypeMatcher.group(1)), NULL.equals(sdoPointTypeMatcher.group(2)) ? null : new BigDecimal(sdoPointTypeMatcher.group(2)), NULL.equals(sdoPointTypeMatcher.group(3)) ? null : new BigDecimal(sdoPointTypeMatcher.group(3)));
                Matcher sdoElemInfoArrayMatcher = sdoElemInfoArrayPattern.matcher(upperVal = upperVal.substring(sdoPointTypeMatcher.end()));
                if (!sdoElemInfoArrayMatcher.find()) {
                    throw new TypeCastException(value, this);
                }
                if (NULL.equals(sdoElemInfoArrayMatcher.group(2))) {
                    sdoElemInfoArray = null;
                } else {
                    String[] elemInfoStrings = sdoElemInfoArrayMatcher.group(1).trim().split("\\s*,\\s*");
                    if (elemInfoStrings.length == 1 && "".equals(elemInfoStrings[0])) {
                        sdoElemInfoArray = new OracleSdoElemInfoArray();
                    } else {
                        BigDecimal[] elemInfos = new BigDecimal[elemInfoStrings.length];
                        for (int index = 0; index < elemInfoStrings.length; ++index) {
                            elemInfos[index] = NULL.equals(elemInfoStrings[index]) ? null : new BigDecimal(elemInfoStrings[index]);
                        }
                        sdoElemInfoArray = new OracleSdoElemInfoArray(elemInfos);
                    }
                }
                upperVal = upperVal.substring(sdoElemInfoArrayMatcher.end());
                Matcher sdoOrdinateArrayMatcher = sdoOrdinateArrayPattern.matcher(upperVal);
                if (!sdoOrdinateArrayMatcher.find()) {
                    throw new TypeCastException(value, this);
                }
                if (NULL.equals(sdoOrdinateArrayMatcher.group(2))) {
                    sdoOrdinateArray = null;
                } else {
                    String[] ordinateStrings = sdoOrdinateArrayMatcher.group(1).trim().split("\\s*,\\s*");
                    if (ordinateStrings.length == 1 && "".equals(ordinateStrings[0])) {
                        sdoOrdinateArray = new OracleSdoOrdinateArray();
                    } else {
                        BigDecimal[] ordinates = new BigDecimal[ordinateStrings.length];
                        for (int index = 0; index < ordinateStrings.length; ++index) {
                            ordinates[index] = NULL.equals(ordinateStrings[index]) ? null : new BigDecimal(ordinateStrings[index]);
                        }
                        sdoOrdinateArray = new OracleSdoOrdinateArray(ordinates);
                    }
                }
                OracleSdoGeometry sdoGeometry = new OracleSdoGeometry(gtype, srid, sdoPoint, sdoElemInfoArray, sdoOrdinateArray);
                return sdoGeometry;
            }
            catch (SQLException e) {
                throw new TypeCastException(value, this, e);
            }
            catch (NumberFormatException e) {
                throw new TypeCastException(value, this, e);
            }
        }
        throw new TypeCastException(value, this);
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        ORAData data = null;
        try {
            data = ((OracleResultSet)resultSet).getORAData(column, OracleSdoGeometry.getORADataFactory());
            if (data != null) {
                return data.toString();
            }
            return NULL;
        }
        catch (SQLException e) {
            throw new TypeCastException(data, this, e);
        }
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        Object castValue = this.typeCast(value);
        if (castValue == null) {
            statement.setNull(column, 2002, "MDSYS.SDO_GEOMETRY");
        } else {
            ((OraclePreparedStatement)statement).setORAData(column, (ORAData)castValue);
        }
    }

    public int compare(Object o1, Object o2) throws TypeCastException {
        logger.debug("compare(o1={}, o2={}) - start", o1, o2);
        try {
            if (this.areObjectsEqual(o1, o2)) {
                return 0;
            }
            Object value1 = this.typeCast(o1);
            Object value2 = this.typeCast(o2);
            if (value1 == null && value2 == null) {
                return 0;
            }
            if (value1 == null && value2 != null) {
                return -1;
            }
            if (value1 != null && value2 == null) {
                return 1;
            }
            if (value1.equals(value2)) {
                return 0;
            }
            return this.compareNonNulls(value1, value2);
        }
        catch (ClassCastException e) {
            throw new TypeCastException(e);
        }
    }
}

