/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.filter;

import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceTableIterator
implements ITableIterator {
    private static final Logger logger = LoggerFactory.getLogger(SequenceTableIterator.class);
    private final String[] _tableNames;
    private final IDataSet _dataSet;
    private int _index = -1;

    public SequenceTableIterator(String[] tableNames, IDataSet dataSet) {
        this._tableNames = tableNames;
        this._dataSet = dataSet;
    }

    public boolean next() throws DataSetException {
        logger.debug("next() - start");
        ++this._index;
        return this._index < this._tableNames.length;
    }

    public ITableMetaData getTableMetaData() throws DataSetException {
        logger.debug("getTableMetaData() - start");
        return this._dataSet.getTableMetaData(this._tableNames[this._index]);
    }

    public ITable getTable() throws DataSetException {
        logger.debug("getTable() - start");
        return this._dataSet.getTable(this._tableNames[this._index]);
    }
}

