/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.common.handlers;

import org.dbunit.dataset.common.handlers.AbstractPipelineComponent;
import org.dbunit.dataset.common.handlers.EscapeHandler;
import org.dbunit.dataset.common.handlers.Helper;
import org.dbunit.dataset.common.handlers.IllegalInputCharacterException;
import org.dbunit.dataset.common.handlers.IsAlnumHandler;
import org.dbunit.dataset.common.handlers.PipelineComponent;
import org.dbunit.dataset.common.handlers.PipelineException;
import org.dbunit.dataset.common.handlers.SeparatorHandler;
import org.dbunit.dataset.common.handlers.WhitespacesHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuoteHandler
extends AbstractPipelineComponent {
    private static final Logger logger = LoggerFactory.getLogger(QuoteHandler.class);
    public static final char QUOTE_CHAR = '\"';

    private QuoteHandler() {
    }

    public static final PipelineComponent ACCEPT() {
        logger.debug("ACCEPT() - start");
        return QuoteHandler.createPipelineComponent(new QuoteHandler(), new AbstractPipelineComponent.ACCEPT());
    }

    public static final PipelineComponent IGNORE() {
        logger.debug("IGNORE() - start");
        return QuoteHandler.createPipelineComponent(new QuoteHandler(), new AbstractPipelineComponent.IGNORE());
    }

    public static final PipelineComponent QUOTE() {
        logger.debug("QUOTE() - start");
        return QuoteHandler.createPipelineComponent(new QuoteHandler(), new QUOTE());
    }

    public static final PipelineComponent UNQUOTE() {
        logger.debug("UNQUOTE() - start");
        return QuoteHandler.createPipelineComponent(new QuoteHandler(), new UNQUOTE());
    }

    public boolean canHandle(char c) throws IllegalInputCharacterException {
        if (logger.isDebugEnabled()) {
            logger.debug("canHandle(c={}) - start", (Object)String.valueOf(c));
        }
        return c == '\"';
    }

    protected static class UNQUOTE
    extends Helper {
        private static final Logger logger = LoggerFactory.getLogger(UNQUOTE.class);

        protected UNQUOTE() {
        }

        public void helpWith(char c) {
            if (logger.isDebugEnabled()) {
                logger.debug("helpWith(c={}) - start", (Object)String.valueOf(c));
            }
            try {
                this.getHandler().getPipeline().removeFront();
                this.getHandler().getPipeline().removeFront();
                this.getHandler().getPipeline().removeFront();
                this.getHandler().getPipeline().removeFront();
                this.getHandler().getPipeline().removeFront();
            }
            catch (PipelineException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        public boolean allowForNoMoreInput() {
            logger.debug("allowForNoMoreInput() - start");
            throw new IllegalStateException("end of input while waiting for a closing quote");
        }
    }

    protected static class QUOTE
    extends Helper {
        private static final Logger logger = LoggerFactory.getLogger(QUOTE.class);

        protected QUOTE() {
        }

        public void helpWith(char c) {
            if (logger.isDebugEnabled()) {
                logger.debug("helpWith(c={}) - start", (Object)String.valueOf(c));
            }
            this.getHandler().getPipeline().putFront(SeparatorHandler.ACCEPT());
            this.getHandler().getPipeline().putFront(WhitespacesHandler.ACCEPT());
            this.getHandler().getPipeline().putFront(IsAlnumHandler.ACCEPT());
            this.getHandler().getPipeline().putFront(QuoteHandler.UNQUOTE());
            this.getHandler().getPipeline().putFront(EscapeHandler.ESCAPE());
        }
    }
}

