/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.common.handlers;

import org.dbunit.dataset.common.handlers.AbstractPipelineComponent;
import org.dbunit.dataset.common.handlers.Helper;
import org.dbunit.dataset.common.handlers.IllegalInputCharacterException;
import org.dbunit.dataset.common.handlers.Pipeline;
import org.dbunit.dataset.common.handlers.PipelineComponent;
import org.dbunit.dataset.common.handlers.PipelineException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnforceHandler
extends AbstractPipelineComponent {
    private static final Logger logger = LoggerFactory.getLogger(EnforceHandler.class);
    private PipelineComponent[] enforcedComponents;
    private PipelineComponent theHandlerComponent;

    private EnforceHandler(PipelineComponent[] components) {
        this.setEnforcedComponents(components);
    }

    public static final PipelineComponent ENFORCE(PipelineComponent component) {
        logger.debug("ENFORCE(component={}) - start", (Object)component);
        return EnforceHandler.ENFORCE(new PipelineComponent[]{component});
    }

    public static final PipelineComponent ENFORCE(PipelineComponent[] components) {
        logger.debug("ENFORCE(components={}) - start", (Object[])components);
        return EnforceHandler.createPipelineComponent(new EnforceHandler(components), new ENFORCE());
    }

    public boolean canHandle(char c) throws IllegalInputCharacterException {
        if (logger.isDebugEnabled()) {
            logger.debug("canHandle(c={}) - start", (Object)String.valueOf(c));
        }
        for (int i = 0; i < this.getEnforcedComponents().length; ++i) {
            if (!this.getEnforcedComponents()[i].canHandle(c)) continue;
            this.setTheHandlerComponent(this.getEnforcedComponents()[i]);
            return true;
        }
        throw new IllegalInputCharacterException("(working on piece #" + this.getPipeline().getProducts().size() + ")" + this.getPipeline().getCurrentProduct().toString() + ": " + "Character '" + c + "' cannot be handled");
    }

    public void setPipeline(Pipeline pipeline) {
        logger.debug("setPipeline(pipeline={}) - start", (Object)pipeline);
        for (int i = 0; i < this.getEnforcedComponents().length; ++i) {
            this.getEnforcedComponents()[i].setPipeline(pipeline);
        }
        super.setPipeline(pipeline);
    }

    protected PipelineComponent[] getEnforcedComponents() {
        logger.debug("getEnforcedComponents() - start");
        return this.enforcedComponents;
    }

    protected void setEnforcedComponents(PipelineComponent[] enforcedComponents) {
        logger.debug("setEnforcedComponents(enforcedComponents={}) - start", (Object[])enforcedComponents);
        this.enforcedComponents = enforcedComponents;
    }

    PipelineComponent getTheHandlerComponent() {
        logger.debug("getTheHandlerComponent() - start");
        return this.theHandlerComponent;
    }

    void setTheHandlerComponent(PipelineComponent theHandlerComponent) {
        logger.debug("setTheHandlerComponent(theHandlerComponent={}) - start", (Object)theHandlerComponent);
        this.theHandlerComponent = theHandlerComponent;
    }

    private static class ENFORCE
    extends Helper {
        private static final Logger logger = LoggerFactory.getLogger(ENFORCE.class);

        private ENFORCE() {
        }

        public void helpWith(char c) {
            if (logger.isDebugEnabled()) {
                logger.debug("helpWith(c={}) - start", (Object)String.valueOf(c));
            }
            try {
                EnforceHandler handler = (EnforceHandler)this.getHandler();
                handler.getTheHandlerComponent().handle(c);
                this.getHandler().getPipeline().removeFront();
            }
            catch (PipelineException e) {
                throw new RuntimeException(e.getMessage());
            }
            catch (IllegalInputCharacterException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
    }
}

