/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset;

import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseInsensitiveTable
implements ITable {
    private static final Logger logger = LoggerFactory.getLogger(CaseInsensitiveTable.class);
    private final ITable _table;

    public CaseInsensitiveTable(ITable table) {
        this._table = table;
    }

    private String getInternalColumnName(String columnName) throws DataSetException {
        logger.debug("getInternalColumnName(columnName={}) - start", (Object)columnName);
        Column[] columns = this._table.getTableMetaData().getColumns();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            if (!columnName.equalsIgnoreCase(column.getColumnName())) continue;
            return column.getColumnName();
        }
        throw new NoSuchColumnException(this._table.getTableMetaData().getTableName(), columnName);
    }

    public ITableMetaData getTableMetaData() {
        return this._table.getTableMetaData();
    }

    public int getRowCount() {
        return this._table.getRowCount();
    }

    public Object getValue(int row, String column) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)column);
        }
        return this._table.getValue(row, this.getInternalColumnName(column));
    }
}

